import { SessionContext } from '@jupyterlab/apputils';
import { ICellModel } from '@jupyterlab/cells';
import { Document, IAdapterOptions, IVirtualPosition, VirtualDocument, WidgetLSPAdapter } from '@jupyterlab/lsp';
import * as nbformat from '@jupyterlab/nbformat';
import { IObservableList } from '@jupyterlab/observables';
import { Session } from '@jupyterlab/services';
import { NotebookPanel } from './panel';
import { Notebook } from './widget';
import { CellList } from './celllist';
type ILanguageInfoMetadata = nbformat.ILanguageInfoMetadata;
export declare class NotebookAdapter extends WidgetLSPAdapter<NotebookPanel> {
    editorWidget: NotebookPanel;
    protected options: IAdapterOptions;
    constructor(editorWidget: NotebookPanel, options: IAdapterOptions);
    /**
     * The wrapped `Notebook` widget.
     */
    readonly editor: Notebook;
    /**
     * Get current path of the document.
     */
    get documentPath(): string;
    /**
     * Get the mime type of the document.
     */
    get mimeType(): string;
    /**
     * Get the file extension of the document.
     */
    get languageFileExtension(): string | undefined;
    /**
     * Get the inner HTMLElement of the document widget.
     */
    get wrapperElement(): HTMLElement;
    /**
     *  Get the list of CM editor with its type in the document,
     */
    get editors(): Document.ICodeBlockOptions[];
    /**
     * Get the activated CM editor.
     */
    get activeEditor(): Document.IEditor | undefined;
    /**
     * Promise that resolves once the adapter is initialized
     */
    get ready(): Promise<void>;
    /**
     * Get the index of editor from the cursor position in the virtual
     * document.
     *
     * @param position - the position of cursor in the virtual document.
     */
    getEditorIndexAt(position: IVirtualPosition): number;
    /**
     * Get the index of input editor
     *
     * @param ceEditor - instance of the code editor
     */
    getEditorIndex(ceEditor: Document.IEditor): number;
    /**
     * Get the wrapper of input editor.
     *
     * @param ceEditor - instance of the code editor
     */
    getEditorWrapper(ceEditor: Document.IEditor): HTMLElement;
    /**
     * Callback on kernel changed event, it will disconnect the
     * document with the language server and then reconnect.
     *
     * @param _session - Session context of changed kernel
     * @param change - Changed data
     */
    onKernelChanged(_session: SessionContext, change: Session.ISessionConnection.IKernelChangedArgs): Promise<void>;
    /**
     * Dispose the widget.
     */
    dispose(): void;
    /**
     * Method to check if the notebook context is ready.
     */
    isReady(): boolean;
    /**
     * Update the virtual document on cell changing event.
     *
     * @param cells - Observable list of changed cells
     * @param change - Changed data
     */
    handleCellChange(cells: CellList, change: IObservableList.IChangedArgs<ICellModel>): Promise<void>;
    /**
     * Generate the virtual document associated with the document.
     */
    createVirtualDocument(): VirtualDocument;
    /**
     * Get the metadata of notebook.
     */
    protected language_info(): ILanguageInfoMetadata;
    /**
     * Initialization function called once the editor and the LSP connection
     * manager is ready. This function will create the virtual document and
     * connect various signals.
     */
    protected initOnceReady(): Promise<void>;
    /**
     * Connect the cell changed event to its handler
     *
     * @param  notebook - The notebook that emitted event.
     */
    private _connectModelSignals;
    /**
     * Update the stored language info with the one from the notebook.
     */
    private _updateLanguageInfo;
    /**
     * Handle the cell changed event
     * @param  notebook - The notebook that emitted event
     * @param cell - Changed cell.
     */
    private _activeCellChanged;
    /**
     * Get the cell at the cursor position of the virtual document.
     * @param  pos - Position in the virtual document.
     */
    private _getCellAt;
    /**
     * Get the cell editor and add new ones to the mappings.
     *
     * @param cell Cell widget
     * @returns Cell editor accessor
     */
    private _getCellEditor;
    /**
     * A map between the editor accessor and the containing cell
     */
    private _editorToCell;
    /**
     * Mapping of cell to editor accessor to ensure accessor uniqueness.
     */
    private _cellToEditor;
    /**
     * Metadata of the notebook
     */
    private _languageInfo;
    private _type;
    private _readyDelegate;
}
export {};
