/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
import { InputGroup } from '@jupyterlab/ui-components';
import * as React from 'react';
import { ShortcutTitleItem } from './ShortcutTitleItem';
export var CommandIDs;
(function (CommandIDs) {
    CommandIDs.showSelectors = 'shortcutui:showSelectors';
    CommandIDs.resetAll = 'shortcutui:resetAll';
})(CommandIDs || (CommandIDs = {}));
function Symbols(props) {
    return (React.createElement("div", { className: "jp-Shortcuts-Symbols" },
        React.createElement("table", null,
            React.createElement("tbody", null,
                React.createElement("tr", null,
                    React.createElement("td", null,
                        React.createElement("kbd", null, "Cmd")),
                    React.createElement("td", null, "\u2318"),
                    React.createElement("td", null,
                        React.createElement("kbd", null, "Ctrl")),
                    React.createElement("td", null, "\u2303")),
                React.createElement("tr", null,
                    React.createElement("td", null,
                        React.createElement("kbd", null, "Alt")),
                    React.createElement("td", null, "\u2325"),
                    React.createElement("td", null,
                        React.createElement("kbd", null, "Shift")),
                    React.createElement("td", null, "\u21E7"))))));
}
function AdvancedOptions(props) {
    const trans = props.translator.load('jupyterlab');
    return (React.createElement("div", { className: "jp-Shortcuts-AdvancedOptions" },
        React.createElement("a", { className: "jp-Shortcuts-AdvancedOptionsLink", onClick: () => props.toggleSelectors() }, props.showSelectors
            ? trans.__('Hide Selectors')
            : trans.__('Show Selectors')),
        React.createElement("a", { className: "jp-Shortcuts-AdvancedOptionsLink", onClick: () => props.resetShortcuts() }, trans.__('Reset All'))));
}
/** React component for top navigation */
export class TopNav extends React.Component {
    constructor(props) {
        super(props);
        this.addMenuCommands();
        this.menu = this.props.external.createMenu();
        this.menu.addItem({ command: CommandIDs.showSelectors });
        this.menu.addItem({ command: CommandIDs.resetAll });
    }
    addMenuCommands() {
        const trans = this.props.external.translator.load('jupyterlab');
        if (!this.props.external.hasCommand(CommandIDs.showSelectors)) {
            this.props.external.addCommand(CommandIDs.showSelectors, {
                label: trans.__('Toggle Selectors'),
                caption: trans.__('Toggle command selectors'),
                execute: () => {
                    this.props.toggleSelectors();
                }
            });
        }
        if (!this.props.external.hasCommand(CommandIDs.resetAll)) {
            this.props.external.addCommand(CommandIDs.resetAll, {
                label: trans.__('Reset All'),
                caption: trans.__('Reset all shortcuts'),
                execute: () => {
                    this.props.resetShortcuts();
                }
            });
        }
    }
    getShortCutTitleItem(title) {
        return (React.createElement("div", { className: "jp-Shortcuts-Cell" },
            React.createElement(ShortcutTitleItem, { title: title, updateSort: this.props.updateSort, active: this.props.currentSort })));
    }
    render() {
        const trans = this.props.external.translator.load('jupyterlab');
        return (React.createElement("div", { className: "jp-Shortcuts-Top" },
            React.createElement("div", { className: "jp-Shortcuts-TopNav" },
                React.createElement(Symbols, null),
                React.createElement(InputGroup, { className: "jp-Shortcuts-Search", type: "text", onChange: event => this.props.updateSearchQuery(event), placeholder: trans.__('Search…'), rightIcon: "ui-components:search" }),
                React.createElement(AdvancedOptions, { toggleSelectors: this.props.toggleSelectors, showSelectors: this.props.showSelectors, resetShortcuts: this.props.resetShortcuts, menu: this.menu, translator: this.props.external.translator })),
            React.createElement("div", { className: "jp-Shortcuts-HeaderRowContainer" },
                React.createElement("div", { className: "jp-Shortcuts-HeaderRow" },
                    this.getShortCutTitleItem(trans.__('Category')),
                    this.getShortCutTitleItem(trans.__('Command')),
                    React.createElement("div", { className: "jp-Shortcuts-Cell" },
                        React.createElement("div", { className: "title-div" }, trans.__('Shortcut'))),
                    this.getShortCutTitleItem(trans.__('Source')),
                    this.props.showSelectors &&
                        this.getShortCutTitleItem(trans.__('Selectors'))))));
    }
}
//# sourceMappingURL=TopNav.js.map