/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
export class MetadataFormProvider {
    constructor() {
        this._items = {};
    }
    add(id, widget) {
        if (!this._items[id]) {
            this._items[id] = widget;
        }
        else {
            console.warn(`A MetadataformWidget is already registered with id ${id}`);
        }
    }
    get(id) {
        if (this._items[id]) {
            return this._items[id];
        }
        else {
            console.warn(`There is no MetadataformWidget registered with id ${id}`);
        }
    }
}
//# sourceMappingURL=metadataformProvider.js.map