/**
 * @packageDocumentation
 * @module metadataform
 */
import { NotebookTools } from '@jupyterlab/notebook';
import { ITranslator } from '@jupyterlab/translation';
import { PartialJSONObject, ReadonlyPartialJSONObject } from '@lumino/coreutils';
import { Message } from '@lumino/messaging';
import { Widget } from '@lumino/widgets';
import { MetadataForm } from './token';
import { FormWidget } from './form';
/**
 * A class that create a metadata form widget
 */
export declare class MetadataFormWidget extends NotebookTools.Tool implements MetadataForm.IMetadataForm {
    /**
     * Construct an empty widget.
     */
    constructor(options: MetadataForm.IOptions);
    /**
     * Get the form object itself.
     */
    get form(): FormWidget | undefined;
    /**
     * Get the list of existing metadataKey (array of string).
     *
     * ## NOTE:
     * The list contains also the conditional fields, which are not necessary
     * displayed and filled.
     */
    get metadataKeys(): string[];
    /**
     * Get the properties of a MetadataKey.
     *
     * @param metadataKey - metadataKey (string).
     */
    getProperties(metadataKey: string): PartialJSONObject | null;
    /**
     * Set properties to a metadataKey.
     *
     * @param metadataKey - metadataKey (string).
     * @param properties - the properties to add or modify.
     */
    setProperties(metadataKey: string, properties: PartialJSONObject): void;
    /**
     * Update the metadata of the current cell or notebook.
     *
     * @param formData - the cell metadata set in the form.
     * @param reload - whether to update the form after updating the metadata.
     *
     * ## Notes
     * Metadata are updated from root only. If some metadata is nested,
     * the whole root object must be updated.
     * This function build an object with all the root object to update
     * in metadata before performing update.
     * It uses an arrow function to allow using 'this' properly when called from a custom field.
     */
    updateMetadata: (formData: ReadonlyPartialJSONObject, reload?: boolean) => void;
    /**
     * Set the content of the widget.
     */
    protected setContent(content: Widget | null): void;
    /**
     * Build widget.
     */
    protected buildWidget(props: MetadataForm.IProps): void;
    /**
     * Update the form when the widget is displayed.
     */
    protected onAfterShow(msg: Message): void;
    /**
     * Handle a change to the active cell.
     */
    protected onActiveCellChanged(msg: Message): void;
    /**
     * Handle a change to the active cell metadata.
     */
    protected onActiveCellMetadataChanged(msg: Message): void;
    protected onActiveNotebookPanelChanged(msg: Message): void;
    /**
     * Handle a change to the active notebook metadata.
     */
    protected onActiveNotebookPanelMetadataChanged(msg: Message): void;
    /**
     * Update the form with current cell metadata, and remove inconsistent fields.
     */
    private _update;
    protected translator: ITranslator;
    private _form;
    private _metadataSchema;
    private _metaInformation;
    private _uiSchema;
    private _trans;
    private _placeholder;
    private _updatingMetadata;
    private _pluginId;
    private _showModified;
    private _notebookModelNull;
}
