// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module metadataform
 */
import { ReactWidget } from '@jupyterlab/apputils';
import { FormComponent } from '@jupyterlab/ui-components';
import validatorAjv8 from '@rjsf/validator-ajv8';
import React from 'react';
/**
 * A ReactWidget with the form itself.
 */
export class FormWidget extends ReactWidget {
    /**
     * Constructs a new FormWidget.
     */
    constructor(props) {
        super();
        this.addClass('jp-FormWidget');
        this._props = props;
    }
    /**
     * Render the form.
     * @returns - The rendered form
     */
    render() {
        const formContext = {
            defaultFormData: this._props.settings.default(),
            updateMetadata: this._props.metadataFormWidget.updateMetadata
        };
        return (React.createElement(FormComponent, { validator: validatorAjv8, schema: this._props.properties, formData: this._props.formData, formContext: formContext, uiSchema: this._props.uiSchema, liveValidate: true, idPrefix: `jp-MetadataForm-${this._props.pluginId}`, onChange: (e) => {
                this._props.metadataFormWidget.updateMetadata(e.formData || {});
            }, compact: true, showModifiedFromDefault: this._props.showModified, translator: this._props.translator }));
    }
}
//# sourceMappingURL=form.js.map