"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_UPLINK = exports.DEFAULT_REGISTRY = void 0;
exports.hasProxyTo = hasProxyTo;
exports.sanityCheckNames = sanityCheckNames;
exports.sanityCheckUplinksProps = sanityCheckUplinksProps;
exports.uplinkSanityCheck = uplinkSanityCheck;
var _assert = _interopRequireDefault(require("assert"));
var _lodash = _interopRequireDefault(require("lodash"));
var _utils = require("@verdaccio/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const DEFAULT_REGISTRY = 'https://registry.npmjs.org';
exports.DEFAULT_REGISTRY = DEFAULT_REGISTRY;
const DEFAULT_UPLINK = 'npmjs';
exports.DEFAULT_UPLINK = DEFAULT_UPLINK;
const BLACKLIST = {
  all: true,
  anonymous: true,
  undefined: true,
  owner: true,
  none: true
};
function uplinkSanityCheck(uplinks, users = BLACKLIST) {
  const newUplinks = _lodash.default.clone(uplinks);
  let newUsers = _lodash.default.clone(users);
  for (const uplink in newUplinks) {
    if (Object.prototype.hasOwnProperty.call(newUplinks, uplink)) {
      if (typeof newUplinks[uplink].cache === 'undefined') {
        newUplinks[uplink].cache = true;
      }
      newUsers = sanityCheckNames(uplink, newUsers);
    }
  }
  return newUplinks;
}
function sanityCheckUplinksProps(configUpLinks) {
  const uplinks = _lodash.default.clone(configUpLinks);
  for (const uplink in uplinks) {
    if (Object.prototype.hasOwnProperty.call(uplinks, uplink)) {
      (0, _assert.default)(uplinks[uplink].url, 'CONFIG: no url for uplink: ' + uplink);
      (0, _assert.default)(_lodash.default.isString(uplinks[uplink].url), 'CONFIG: wrong url format for uplink: ' + uplink);
      uplinks[uplink].url = uplinks[uplink].url.replace(/\/$/, '');
    }
  }
  return uplinks;
}
function hasProxyTo(pkg, upLink, packages) {
  const matchedPkg = (0, _utils.getMatchedPackagesSpec)(pkg, packages);
  const proxyList = typeof matchedPkg !== 'undefined' ? matchedPkg.proxy : [];
  if (proxyList) {
    return proxyList.some(curr => upLink === curr);
  }
  return false;
}
function sanityCheckNames(item, users) {
  (0, _assert.default)(item !== 'all' && item !== 'owner' && item !== 'anonymous' && item !== 'undefined' && item !== 'none', 'CONFIG: reserved uplink name: ' + item);
  (0, _assert.default)(!item.match(/\s/), 'CONFIG: invalid uplink name: ' + item);
  (0, _assert.default)(_lodash.default.isNil(users[item]), 'CONFIG: duplicate uplink name: ' + item);
  users[item] = true;
  return users;
}
//# sourceMappingURL=uplinks.js.map