"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromJStoYAML = fromJStoYAML;
exports.parseConfigFile = parseConfigFile;
var _debug = _interopRequireDefault(require("debug"));
var _fs = _interopRequireDefault(require("fs"));
var _jsYaml = _interopRequireDefault(require("js-yaml"));
var _lodash = require("lodash");
var _core = require("@verdaccio/core");
var _configUtils = require("./config-utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const debug = (0, _debug.default)('verdaccio:config:parse');

/**
 * Parse a config file from yaml to JSON.
 * @param configPath the absolute path of the configuration file
 */
function parseConfigFile(configPath) {
  debug('parse config file %s', configPath);
  if (!(0, _configUtils.fileExists)(configPath)) {
    throw new Error(`config file does not exist or not reachable`);
  }
  debug('parsing config file: %o', configPath);
  try {
    if (/\.ya?ml$/i.test(configPath)) {
      const yamlConfig = _jsYaml.default.load(_fs.default.readFileSync(configPath, 'utf8'), {
        strict: false
      });
      return Object.assign({}, yamlConfig, {
        configPath,
        // @deprecated use configPath instead
        config_path: configPath
      });
    }
    const jsonConfig = require(configPath);
    return Object.assign({}, jsonConfig, {
      configPath,
      // @deprecated use configPath instead
      config_path: configPath
    });
  } catch (e) {
    if (e.code !== 'MODULE_NOT_FOUND') {
      debug('config module not found %o error: %o', configPath, e.message);
      throw Error(_core.APP_ERROR.CONFIG_NOT_VALID);
    }
    throw e;
  }
}
function fromJStoYAML(config) {
  debug('convert config from JSON to YAML');
  if ((0, _lodash.isObject)(config)) {
    return _jsYaml.default.dump(config);
  } else {
    throw new Error(`config is not a valid object`);
  }
}
//# sourceMappingURL=parse.js.map