"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultUserRateLimiting = exports.WEB_TITLE = exports.Config = void 0;
var _assert = _interopRequireDefault(require("assert"));
var _debug = _interopRequireDefault(require("debug"));
var _lodash = _interopRequireDefault(require("lodash"));
var _core = require("@verdaccio/core");
var _warningUtils = require("@verdaccio/core/build/warning-utils");
var _utils = require("@verdaccio/utils");
var _agent = require("./agent");
var _packageAccess = require("./package-access");
var _security = require("./security");
var _serverSettings = _interopRequireDefault(require("./serverSettings"));
var _token = require("./token");
var _uplinks = require("./uplinks");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const strategicConfigProps = ['uplinks', 'packages'];
const allowedEnvConfig = ['http_proxy', 'https_proxy', 'no_proxy'];
const debug = (0, _debug.default)('verdaccio:config');
const WEB_TITLE = 'Verdaccio';

// we limit max 1000 request per 15 minutes on user endpoints
exports.WEB_TITLE = WEB_TITLE;
const defaultUserRateLimiting = {
  windowMs: 15 * 60 * 1000,
  // 15 minutes
  max: 1000
};

/**
 * Coordinates the application configuration
 */
exports.defaultUserRateLimiting = defaultUserRateLimiting;
class Config {
  /**
   * @deprecated use configPath or config.getConfigPath();
   */

  // @ts-ignore

  constructor(config, configOptions = {
    forceEnhancedLegacySignature: true
  }) {
    var _config$flags$searchR, _config$flags;
    const self = this;
    this.configOptions = configOptions;
    this.storage = process.env.VERDACCIO_STORAGE_PATH || config.storage;
    if (!config.configPath) {
      var _config$config_path;
      // backport self_path for previous to version 6
      // @ts-expect-error
      config.configPath = (_config$config_path = config.config_path) !== null && _config$config_path !== void 0 ? _config$config_path : config.self_path;
      if (!config.configPath) {
        throw new Error('configPath property is required');
      }
    }
    this.configPath = config.configPath;
    this.self_path = this.configPath;
    debug('config path: %s', this.configPath);
    this.plugins = config.plugins;
    this.security = _lodash.default.merge(_security.defaultSecurity, config.security);
    this.serverSettings = _serverSettings.default;
    this.flags = {
      searchRemote: (_config$flags$searchR = (_config$flags = config.flags) === null || _config$flags === void 0 ? void 0 : _config$flags.searchRemote) !== null && _config$flags$searchR !== void 0 ? _config$flags$searchR : true
    };
    this.user_agent = config.user_agent;
    for (const configProp in config) {
      if (self[configProp] == null) {
        self[configProp] = config[configProp];
      }
    }
    if (typeof this.user_agent === 'undefined') {
      // by default user agent is hidden
      debug('set default user agent');
      this.user_agent = (0, _agent.getUserAgent)(false);
    }
    this.userRateLimit = {
      ...defaultUserRateLimiting,
      ...(config === null || config === void 0 ? void 0 : config.userRateLimit)
    };

    // some weird shell scripts are valid yaml files parsed as string
    (0, _assert.default)(_lodash.default.isObject(config), _core.APP_ERROR.CONFIG_NOT_VALID);

    // sanity check for strategic config properties
    strategicConfigProps.forEach(function (x) {
      if (self[x] == null) {
        self[x] = {};
      }
      (0, _assert.default)((0, _utils.isObject)(self[x]), `CONFIG: bad "${x}" value (object expected)`);
    });
    this.uplinks = (0, _uplinks.sanityCheckUplinksProps)((0, _uplinks.uplinkSanityCheck)(this.uplinks));
    this.packages = (0, _packageAccess.normalisePackageAccess)(self.packages);

    // loading these from ENV if aren't in config
    allowedEnvConfig.forEach(envConf => {
      if (!(envConf in self)) {
        self[envConf] = process.env[envConf] || process.env[envConf.toUpperCase()];
      }
    });

    // unique identifier of self server (or a cluster), used to avoid loops
    // @ts-ignore
    if (!this.server_id) {
      this.server_id = (0, _utils.generateRandomHexString)(6);
    }
  }
  getConfigPath() {
    return this.configPath;
  }

  /**
   * Check for package spec
   */
  getMatchedPackagesSpec(pkgName) {
    // TODO: remove this method and replace by library utils
    return (0, _utils.getMatchedPackagesSpec)(pkgName, this.packages);
  }

  /**
   * Store or create whether receive a secret key
   * @secret external secret key
   */
  checkSecretKey(secret) {
    var _this$secret;
    debug('check secret key');
    if (typeof secret === 'string' && _lodash.default.isEmpty(secret) === false) {
      this.secret = secret;
      debug('reusing previous key');
      return secret;
    }
    // generate a new a secret key
    // FUTURE: this might be an external secret key, perhaps within config file?
    debug('generate a new key');
    //
    if (this.configOptions.forceEnhancedLegacySignature) {
      this.secret = (0, _token.generateRandomSecretKey)();
    } else {
      this.secret = this.security.enhancedLegacySignature === true ? (0, _token.generateRandomSecretKey)() : (0, _utils.generateRandomHexString)(32);
      // set this to false allow use old token signature and is not recommended
      // only use for migration reasons, major release will remove this property and
      // set it by default
      if (this.security.enhancedLegacySignature === false) {
        _core.warningUtils.emit(_warningUtils.Codes.VERWAR005);
      }
    }
    debug('generated a new secret key %s', (_this$secret = this.secret) === null || _this$secret === void 0 ? void 0 : _this$secret.length);
    return this.secret;
  }
}
exports.Config = Config;
//# sourceMappingURL=config.js.map