import { Config as AppConfig, AuthConf, ConfigYaml, FlagsConfig, PackageAccess, PackageList, RateLimit, Security, ServerSettingsConf } from '@verdaccio/types';
export declare const WEB_TITLE = "Verdaccio";
export declare const defaultUserRateLimiting: {
    windowMs: number;
    max: number;
};
/**
 * Coordinates the application configuration
 */
declare class Config implements AppConfig {
    user_agent: string | undefined;
    uplinks: any;
    packages: PackageList;
    users: any;
    auth: AuthConf;
    server_id: string;
    configPath: string;
    /**
     * @deprecated use configPath or config.getConfigPath();
     */
    self_path: string;
    storage: string | void;
    plugins: string | void | null;
    security: Security;
    serverSettings: ServerSettingsConf;
    secret: string;
    flags: FlagsConfig;
    userRateLimit: RateLimit;
    private configOptions;
    constructor(config: ConfigYaml & {
        config_path: string;
    }, configOptions?: {
        forceEnhancedLegacySignature: boolean;
    });
    getConfigPath(): string;
    /**
     * Check for package spec
     */
    getMatchedPackagesSpec(pkgName: string): PackageAccess | void;
    /**
     * Store or create whether receive a secret key
     * @secret external secret key
     */
    checkSecretKey(secret?: string): string;
}
export { Config };
