"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fileExists = fileExists;
exports.folderExists = folderExists;
var _fs = _interopRequireDefault(require("fs"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/**
 * Check whether the path already exist.
 * @param {String} path
 * @return {Boolean}
 */
function folderExists(path) {
  try {
    const stat = _fs.default.statSync(path);
    return stat.isDirectory();
  } catch (_) {
    return false;
  }
}

/**
 * Check whether the file already exist.
 * @param {String} path
 * @return {Boolean}
 */
function fileExists(path) {
  try {
    const stat = _fs.default.statSync(path);
    return stat.isFile();
  } catch (_) {
    return false;
  }
}
//# sourceMappingURL=config-utils.js.map