import { Widget } from '@lumino/widgets';
import { Message } from '@lumino/messaging';
/**
 * Placeholder widget options
 */
export interface IPlaceholderOptions {
    /**
     * Prompt element CSS class
     */
    promptClass: string;
    /**
     * Ellipsis button callback
     */
    callback: (e: MouseEvent) => void;
}
/**
 * An base class for placeholders
 *
 * ### Notes
 * A placeholder is the element that is shown when input/output
 * is hidden.
 */
export declare class Placeholder extends Widget {
    /**
     * Construct a new placeholder.
     */
    constructor(options: IPlaceholderOptions);
    protected onAfterAttach(msg: Message): void;
    protected onBeforeDetach(msg: Message): void;
    private _callback;
    private _button;
}
/**
 * The input placeholder class.
 */
export declare class InputPlaceholder extends Placeholder {
    /**
     * Construct a new input placeholder.
     */
    constructor(callback: (e: MouseEvent) => void);
}
/**
 * The output placeholder class.
 */
export declare class OutputPlaceholder extends Placeholder {
    /**
     * Construct a new output placeholder.
     */
    constructor(callback: (e: MouseEvent) => void);
}
