"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getByQualityPriorityValue = getByQualityPriorityValue;
/**
 * Quality values, or q-values and q-factors, are used to describe the order
 * of priority of values in a comma-separated list.
 * It is a special syntax allowed in some HTTP headers and in HTML.
 * https://developer.mozilla.org/en-US/docs/Glossary/Quality_values
 * @param headerValue
 */
function getByQualityPriorityValue(headerValue) {
  if (typeof headerValue !== 'string') {
    return '';
  }
  const split = headerValue.split(',');
  if (split.length <= 1) {
    const qList = split[0].split(';');
    return qList[0];
  }
  let [header] = split.reduce((acc, item) => {
    const qList = item.split(';');
    if (qList.length > 1) {
      const [accept, q] = qList;
      const [, query] = q.split('=');
      acc.push([accept.trim(), query ? query : 0]);
    } else {
      acc.push([qList[0], 0]);
    }
    return acc;
  }, []).sort(function (a, b) {
    return b[1] - a[1];
  });
  return header[0];
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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