/// <reference types="node" />
import { NextFunction, Request, Response } from 'express';
import lunrMutable from 'lunr-mutable-indexes';
import { AuthPluginPackage, Author, Callback, Config, IBasicAuth, IBasicStorage, IPluginStorage, IPluginStorageFilter, IReadTarball, IStorageManager, ITokenActions, JWTSignOptions, Logger, Package, PackageAccess, RemoteUser, Token, TokenFilter, UpLinkConf, Version, Versions, StringValue as verdaccio$StringValue } from '@verdaccio/types';
export declare type StringValue = verdaccio$StringValue;
export interface LegacyPackageList {
    [key: string]: LegacyPackageAccess;
}
export declare type LegacyPackageAccess = PackageAccess & {
    allow_publish?: string[];
    allow_proxy?: string[];
    allow_access?: string[];
    proxy_access?: string[];
    unpublish?: string[];
};
export declare type MatchedPackage = PackageAccess | void;
export declare type JWTPayload = RemoteUser & {
    password?: string;
};
export interface AESPayload {
    user: string;
    password: string;
}
export interface AuthTokenHeader {
    scheme: string;
    token: string;
}
export declare type BasicPayload = AESPayload | void;
export declare type AuthMiddlewarePayload = RemoteUser | BasicPayload;
export interface ProxyList {
    [key: string]: IProxy;
}
export interface Utils {
    ErrorCode: any;
    getLatestVersion: Callback;
    isObject: (value: any) => boolean;
    validate_name: (value: any) => boolean;
    tag_version: (value: any, version: string, tag: string) => void;
    normalizeDistTags: (pkg: Package) => void;
    semverSort: (keys: string[]) => string[];
}
export interface Profile {
    tfa: boolean;
    name: string;
    email: string;
    email_verified: string;
    created: string;
    updated: string;
    cidr_whitelist: any;
    fullname: string;
}
export declare type $RequestExtend = Request & {
    remote_user?: any;
    log: Logger;
};
export declare type $ResponseExtend = Response & {
    cookies?: any;
};
export declare type $NextFunctionVer = NextFunction & any;
export declare type $SidebarPackage = Package & {
    latest: any;
};
export interface IAuthWebUI {
    jwtEncrypt(user: RemoteUser, signOptions: JWTSignOptions): Promise<string>;
    aesEncrypt(buf: Buffer): Buffer;
}
interface IAuthMiddleware {
    apiJWTmiddleware(): $NextFunctionVer;
    webUIJWTmiddleware(): $NextFunctionVer;
}
export interface IAuth extends IBasicAuth<Config>, IAuthMiddleware, IAuthWebUI {
    config: Config;
    logger: Logger;
    secret: string;
    plugins: any[];
    allow_unpublish(pkg: AuthPluginPackage, user: RemoteUser, callback: Callback): void;
}
export interface IWebSearch {
    index: lunrMutable.index;
    storage: IStorageHandler;
    query(query: string): any;
    add(pkg: Version): void;
    remove(name: string): void;
    reindex(): void;
    configureStorage(storage: IStorageHandler): void;
}
export declare type UpLinkConfLocal = UpLinkConf & {
    no_proxy?: string;
};
export interface IProxy {
    config: UpLinkConfLocal;
    failed_requests: number;
    userAgent: string;
    ca?: string | void;
    logger: Logger;
    server_id: string;
    url: any;
    maxage: number;
    timeout: number;
    max_fails: number;
    fail_timeout: number;
    upname: string;
    fetchTarball(url: string): IReadTarball;
    isUplinkValid(url: string): boolean;
    search(options: any): any;
    getRemoteMetadata(name: string, options: any, callback: Callback): void;
}
export interface IStorage extends IBasicStorage<Config>, ITokenActions {
    config: Config;
    storagePlugin: IPluginStorage<Config>;
    logger: Logger;
}
export interface IGetPackageOptions {
    callback: Callback;
    name: string;
    keepUpLinkData: boolean;
    uplinksLook: boolean;
    req: any;
    abbreviated?: boolean;
}
export interface ISyncUplinks {
    uplinksLook?: boolean;
    etag?: string;
    req?: Request;
}
export declare type IPluginFilters = IPluginStorageFilter<Config>[];
export interface IStorageHandler extends IStorageManager<Config>, ITokenActions {
    config: Config;
    localStorage: IStorage | null;
    filters: IPluginFilters;
    uplinks: ProxyList;
    init(config: Config, filters: IPluginFilters): Promise<string>;
    saveToken(token: Token): Promise<any>;
    deleteToken(user: string, tokenKey: string): Promise<any>;
    readTokens(filter: TokenFilter): Promise<Token[]>;
    _syncUplinksMetadata(name: string, packageInfo: Package, options: any, callback: Callback): void;
    _updateVersionsHiddenUpLink(versions: Versions, upLink: IProxy): void;
}
/**
 * @property { string | number | Styles }  [ruleOrSelector]
 */
export interface Styles {
    [ruleOrSelector: string]: string | number | Styles;
}
export declare type AuthorAvatar = Author & {
    avatar?: string;
};
export {};
