/// <reference types="node" />
import { parseConfigFile } from '@verdaccio/config';
import { errorUtils, validatioUtils } from '@verdaccio/core';
import { StringValue } from '@verdaccio/types';
import { Author, Config, Package, Version } from '@verdaccio/types';
import { buildToken as buildTokenUtil } from '@verdaccio/utils';
import { AuthorAvatar } from '../types';
export declare function convertPayloadToBase64(payload: string): Buffer;
/**
 * Check whether an element is an Object
 * @param {*} obj the element
 * @return {Boolean}
 */
export declare const isObject: typeof validatioUtils.isObject;
/**
 * @deprecated not used un v6
 */
export declare function isObjectOrArray(obj: any): boolean;
export declare function tagVersion(data: Package, version: string, tag: StringValue): boolean;
/**
 * Gets version from a package object taking into account semver weirdness.
 * @return {String} return the semantic version of a package
 */
export declare function getVersion(pkg: Package, version: any): Version | void;
/**
 * Parse an internet address
 * Allow:
 - https:localhost:1234        - protocol + host + port
 - localhost:1234              - host + port
 - 1234                        - port
 - http::1234                  - protocol + port
 - https://localhost:443/      - full url + https
 - http://[::1]:443/           - ipv6
 - unix:/tmp/http.sock         - unix sockets
 - https://unix:/tmp/http.sock - unix sockets (https)
 * @param {*} urlAddress the internet address definition
 * @return {Object|Null} literal object that represent the address parsed
 */
export declare function parseAddress(urlAddress: any): any;
/**
 * Function filters out bad semver versions and sorts the array.
 * @return {Array} sorted Array
 */
export declare function semverSort(listVersions: string[]): string[];
/**
 * Flatten arrays of tags.
 * @param {*} data
 */
export declare function normalizeDistTags(pkg: Package): void;
/**
 * Parse an internal string to number
 * @param {*} interval
 * @return {Number}
 */
export declare function parseInterval(interval: any): number;
export declare const ErrorCode: {
    getConflict: typeof errorUtils.getConflict;
    getBadData: typeof errorUtils.getBadData;
    getBadRequest: typeof errorUtils.getBadRequest;
    getInternalError: typeof errorUtils.getInternalError;
    getUnauthorized: typeof errorUtils.getUnauthorized;
    getForbidden: typeof errorUtils.getForbidden;
    getServiceUnavailable: typeof errorUtils.getServiceUnavailable;
    getNotFound: typeof errorUtils.getNotFound;
    getCode: typeof errorUtils.getCode;
};
/**
 * Check whether the path already exist.
 * @param {String} path
 * @return {Boolean}
 */
export declare function folderExists(path: string): boolean;
/**
 * Check whether the file already exist.
 * @param {String} path
 * @return {Boolean}
 */
export declare function fileExists(path: string): boolean;
export declare function sortByName(packages: any[], orderAscending?: boolean | void): string[];
export declare function addScope(scope: string, packageName: string): string;
export declare function deleteProperties(propertiesToDelete: string[], objectItem: any): any;
export declare function addGravatarSupport(pkgInfo: Package, online?: boolean): AuthorAvatar;
/**
 * parse package readme - markdown/ascii
 * @param {String} packageName name of package
 * @param {String} readme package readme

 * @return {String} converted html template
 */
export declare function parseReadme(packageName: string, readme: string): string | void;
export declare type AuthorFormat = Author | string | null | object | void;
/**
 * Formats author field for webui.
 * @see https://docs.npmjs.com/files/package.json#author
 * @param {string|object|undefined} author
 */
export declare function formatAuthor(author: AuthorFormat): any;
/**
 * Apply whitespaces based on the length
 * @param {*} str the log message
 * @return {String}
 */
export declare function pad(str: any, max: any): string;
/**
 * return a masquerade string with its first and last {charNum} and three dots in between.
 * @param {String} str
 * @param {Number} charNum
 * @returns {String}
 */
export declare function mask(str: string, charNum?: number): string;
export declare function encodeScopedUri(packageName: any): string;
export declare function hasDiffOneKey(versions: any): boolean;
export declare function isVersionValid(packageMeta: any, packageVersion: any): boolean;
export declare function isRelatedToDeprecation(pkgInfo: Package): boolean;
export declare function validateURL(publicUrl: string | void): boolean;
export declare function isHost(url?: string, options?: {}): boolean;
export declare function hasLogin(config: Config): boolean;
export { buildTokenUtil as buildToken, parseConfigFile };
