"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupUpLinks = setupUpLinks;
exports.updateVersionsHiddenUpLink = updateVersionsHiddenUpLink;
var _upStorage = _interopRequireDefault(require("./up-storage"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/**
 * Set up the Up Storage for each link.
 */
function setupUpLinks(config) {
  const uplinks = {};
  for (const uplinkName in config.uplinks) {
    if (Object.prototype.hasOwnProperty.call(config.uplinks, uplinkName)) {
      // instance for each up-link definition
      const proxy = new _upStorage.default(config.uplinks[uplinkName], config);
      proxy.upname = uplinkName;
      uplinks[uplinkName] = proxy;
    }
  }
  return uplinks;
}
function updateVersionsHiddenUpLink(versions, upLink) {
  for (const i in versions) {
    if (Object.prototype.hasOwnProperty.call(versions, i)) {
      const version = versions[i];

      // holds a "hidden" value to be used by the package storage.

      version[Symbol.for('__verdaccio_uplink')] = upLink.upname;
    }
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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