"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lunrMutableIndexes = _interopRequireDefault(require("lunr-mutable-indexes"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/**
 * Handle the search Indexer.
 */
class Search {
  // @ts-ignore

  /**
   * Constructor.
   */
  constructor() {
    _defineProperty(this, "index", void 0);
    _defineProperty(this, "storage", void 0);
    this.index = (0, _lunrMutableIndexes.default)(function () {
      // FIXME: there is no types for this library
      /* eslint no-invalid-this:off */
      // @ts-ignore
      this.field('name', {
        boost: 10
      });
      // @ts-ignore
      this.field('description', {
        boost: 4
      });
      // @ts-ignore
      this.field('author', {
        boost: 6
      });
      // @ts-ignore
      this.field('keywords', {
        boost: 7
      });
      // @ts-ignore
      this.field('version');
      // @ts-ignore
      this.field('readme');
    });
  }

  /**
   * Performs a query to the indexer.
   * If the keyword is a * it returns all local elements
   * otherwise performs a search
   * @param {*} q the keyword
   * @return {Array} list of results.
   */
  query(query) {
    const localStorage = this.storage.localStorage;
    const hasScope = query.startsWith('@');
    // FIXME: lunr-mutable-indexes ignored '@' during indexing
    if (hasScope) {
      query = query.replace('@', '');
    }
    const results = query === '*' ? localStorage.storagePlugin.get(items => {
      items.map(function (pkg) {
        return {
          ref: pkg,
          score: 1
        };
      });
    }) : this.index.search(`*${query}*`);
    return hasScope ? results.filter(({
      ref
    }) => ref.startsWith('@')) : results;
  }

  /**
   * Add a new element to index
   * @param {*} pkg the package
   */
  add(pkg) {
    this.index.add({
      id: pkg.name,
      name: pkg.name,
      description: pkg.description,
      version: `v${pkg.version}`,
      keywords: pkg.keywords,
      author: pkg._npmUser ? pkg._npmUser.name : '???'
    });
  }

  /**
   * Remove an element from the index.
   * @param {*} name the id element
   */
  remove(name) {
    this.index.remove({
      id: name
    });
  }

  /**
   * Force a re-index.
   */
  reindex() {
    this.storage.getLocalDatabase((error, packages) => {
      if (error) {
        // that function shouldn't produce any
        throw error;
      }
      let i = packages.length;
      while (i--) {
        this.add(packages[i]);
      }
    });
  }

  /**
   * Set up the {Storage}
   * @param {*} storage An storage reference.
   */
  configureStorage(storage) {
    this.storage = storage;
    this.reindex();
  }
}
var _default = new Search();
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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