import lunrMutable from 'lunr-mutable-indexes';
import { Version } from '@verdaccio/types';
import { IStorageHandler, IWebSearch } from '../types';
/**
 * Handle the search Indexer.
 */
declare class Search implements IWebSearch {
    index: lunrMutable.index;
    storage: IStorageHandler;
    /**
     * Constructor.
     */
    constructor();
    /**
     * Performs a query to the indexer.
     * If the keyword is a * it returns all local elements
     * otherwise performs a search
     * @param {*} q the keyword
     * @return {Array} list of results.
     */
    query(query: string): any[];
    /**
     * Add a new element to index
     * @param {*} pkg the package
     */
    add(pkg: Version): void;
    /**
     * Remove an element from the index.
     * @param {*} name the id element
     */
    remove(name: string): void;
    /**
     * Force a re-index.
     */
    reindex(): void;
    /**
     * Set up the {Storage}
     * @param {*} storage An storage reference.
     */
    configureStorage(storage: IStorageHandler): void;
}
declare const _default: Search;
export default _default;
