"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notifyRequest = notifyRequest;
var _debug = _interopRequireDefault(require("debug"));
var _isNil = _interopRequireDefault(require("lodash/isNil"));
var _request = _interopRequireDefault(require("request"));
var _constants = require("../constants");
var _logger = require("../logger");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const debug = (0, _debug.default)('verdaccio:notify-request');
function notifyRequest(options, content) {
  return new Promise((resolve, reject) => {
    (0, _request.default)(options, function (err, response, body) {
      if (err || response.statusCode >= _constants.HTTP_STATUS.BAD_REQUEST) {
        const errorMessage = (0, _isNil.default)(err) ? response.body : err.message;
        _logger.logger.error({
          errorMessage
        }, 'notify service has thrown an error: @{errorMessage}');
        reject(errorMessage);
      }
      _logger.logger.info({
        content
      }, 'A notification has been shipped: @{content}');
      if ((0, _isNil.default)(body) === false) {
        _logger.logger.debug({
          body
        }, ' body: @{body}');
        resolve(body);
      }
      reject(Error('body is missing'));
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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