"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleNotify = handleNotify;
exports.notify = notify;
exports.sendNotification = sendNotification;
var _handlebars = _interopRequireDefault(require("handlebars"));
var _lodash = _interopRequireDefault(require("lodash"));
var _notifyRequest = require("./notify-request");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function handleNotify(metadata, notifyEntry, remoteUser, publishedPackage) {
  let regex;
  if (metadata.name && notifyEntry.packagePattern) {
    regex = new RegExp(notifyEntry.packagePattern, notifyEntry.packagePatternFlags || '');
    if (!regex.test(metadata.name)) {
      return;
    }
  }
  const template = _handlebars.default.compile(notifyEntry.content);
  // don't override 'publisher' if package.json already has that
  /* eslint no-unused-vars: 0 */
  /* eslint @typescript-eslint/no-unused-vars: 0 */
  // @ts-ignore
  if (_lodash.default.isNil(metadata.publisher)) {
    // @ts-ignore
    metadata = _objectSpread(_objectSpread({}, metadata), {}, {
      publishedPackage,
      publisher: {
        name: remoteUser.name
      }
    });
  }
  const content = template(metadata);
  const options = {
    body: content,
    url: ''
  };

  // provides fallback support, it's accept an Object {} and Array of {}
  if (notifyEntry.headers && _lodash.default.isArray(notifyEntry.headers)) {
    const header = {};
    notifyEntry.headers.map(function (item) {
      if (Object.is(item, item)) {
        for (const key in item) {
          /* eslint no-prototype-builtins: 0 */
          if (item.hasOwnProperty(key)) {
            header[key] = item[key];
          }
        }
      }
    });
    options.headers = header;
  } else if (Object.is(notifyEntry.headers, notifyEntry.headers)) {
    options.headers = notifyEntry.headers;
  }
  options.method = notifyEntry.method;
  if (notifyEntry.endpoint) {
    options.url = notifyEntry.endpoint;
  }
  return (0, _notifyRequest.notifyRequest)(options, content);
}
function sendNotification(metadata, notify, remoteUser, publishedPackage) {
  return handleNotify(metadata, notify, remoteUser, publishedPackage);
}
function notify(metadata, config, remoteUser, publishedPackage) {
  if (config.notify) {
    // @ts-ignore
    if (config.notify.content) {
      return sendNotification(metadata, config.notify, remoteUser, publishedPackage);
    }
    // multiple notifications endpoints PR #108
    return Promise.all(_lodash.default.map(config.notify, key => sendNotification(metadata, key, remoteUser, publishedPackage)));
  }
  return Promise.resolve();
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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