"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeVersions = mergeVersions;
var _lodash = _interopRequireDefault(require("lodash"));
var _semver = _interopRequireDefault(require("semver"));
var _constants = require("./constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/**
 * Function gets a local info and an info from uplinks and tries to merge it
 exported for unit tests only.
  * @param {*} local
  * @param {*} up
  * @param {*} config
  * @static
  */
function mergeVersions(local, up) {
  // copy new versions to a cache
  // NOTE: if a certain version was updated, we can't refresh it reliably
  for (const i in up.versions) {
    if (_lodash.default.isNil(local.versions[i])) {
      local.versions[i] = up.versions[i];
    }
  }
  for (const i in up[_constants.DIST_TAGS]) {
    if (local[_constants.DIST_TAGS][i] !== up[_constants.DIST_TAGS][i]) {
      if (!local[_constants.DIST_TAGS][i] || _semver.default.lte(local[_constants.DIST_TAGS][i], up[_constants.DIST_TAGS][i])) {
        local[_constants.DIST_TAGS][i] = up[_constants.DIST_TAGS][i];
      }
      if (i === 'latest' && local[_constants.DIST_TAGS][i] === up[_constants.DIST_TAGS][i]) {
        // if remote has more fresh package, we should borrow its readme
        local.readme = up.readme;
      }
    }
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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