"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasProxyTo = hasProxyTo;
exports.normalisePackageAccess = normalisePackageAccess;
exports.normalizeUserList = normalizeUserList;
var _assert = _interopRequireDefault(require("assert"));
var _lodash = _interopRequireDefault(require("lodash"));
var _utils = require("@verdaccio/utils");
var _utils2 = require("./utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/**
 * Normalize user list.
 * @return {Array}
 */
function normalizeUserList(oldFormat, newFormat) {
  const result = [];
  /* eslint prefer-rest-params: "off" */

  for (let i = 0; i < arguments.length; i++) {
    if (arguments[i] == null) {
      continue;
    }

    // if it's a string, split it to array
    if (_lodash.default.isString(arguments[i])) {
      result.push(arguments[i].split(/\s+/));
    } else if (Array.isArray(arguments[i])) {
      result.push(arguments[i]);
    } else {
      throw _utils2.ErrorCode.getInternalError('CONFIG: bad package acl (array or string expected): ' + JSON.stringify(arguments[i]));
    }
  }
  return _lodash.default.flatten(result);
}

/**
 * Check whether an uplink can proxy
 */
function hasProxyTo(pkg, upLink, packages) {
  const matchedPkg = (0, _utils.getMatchedPackagesSpec)(pkg, packages);
  const proxyList = typeof matchedPkg !== 'undefined' ? matchedPkg.proxy : [];
  if (proxyList) {
    return proxyList.some(curr => upLink === curr);
  }
  return false;
}
function normalisePackageAccess(packages) {
  const normalizedPkgs = _objectSpread({}, packages);
  // add a default rule for all packages to make writing plugins easier
  if (_lodash.default.isNil(normalizedPkgs['**'])) {
    normalizedPkgs['**'] = {
      access: [],
      publish: [],
      proxy: []
    };
  }
  for (const pkg in packages) {
    if (Object.prototype.hasOwnProperty.call(packages, pkg)) {
      (0, _assert.default)(_lodash.default.isObject(packages[pkg]) && _lodash.default.isArray(packages[pkg]) === false, `CONFIG: bad "'${pkg}'" package description (object expected)`);
      normalizedPkgs[pkg].access = normalizeUserList(packages[pkg].allow_access, packages[pkg].access);
      delete normalizedPkgs[pkg].allow_access;
      normalizedPkgs[pkg].publish = normalizeUserList(packages[pkg].allow_publish, packages[pkg].publish);
      delete normalizedPkgs[pkg].allow_publish;
      normalizedPkgs[pkg].proxy = normalizeUserList(packages[pkg].proxy_access, packages[pkg].proxy);
      delete normalizedPkgs[pkg].proxy_access;
      // if unpublish is not defined, we set to false to fallback in publish access
      normalizedPkgs[pkg].unpublish = _lodash.default.isUndefined(packages[pkg].unpublish) ? false : normalizeUserList([], packages[pkg].unpublish);
    }
  }
  return normalizedPkgs;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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