"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MIN_NODE_VERSION = void 0;
exports.getListListenAddresses = getListListenAddresses;
exports.isVersionValid = isVersionValid;
exports.resolveConfigPath = void 0;
var _path = _interopRequireDefault(require("path"));
var _semver = _interopRequireDefault(require("semver"));
var _constants = require("../constants");
var _utils = require("../utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const logger = require('../logger');
const resolveConfigPath = function (storageLocation, file) {
  return _path.default.resolve(_path.default.dirname(storageLocation), file);
};
exports.resolveConfigPath = resolveConfigPath;
const MIN_NODE_VERSION = '12';
exports.MIN_NODE_VERSION = MIN_NODE_VERSION;
function isVersionValid(version) {
  return _semver.default.satisfies(version, `>=${MIN_NODE_VERSION}`);
}

/**
 * Retrieve all addresses defined in the config file.
 * Verdaccio is able to listen multiple ports
 * @param {String} argListen
 * @param {String} configListen
 * eg:
 *  listen:
 - localhost:5555
 - localhost:5557
 @return {Array}
 */
function getListListenAddresses(argListen, configListen) {
  // command line || config file || default
  let addresses;
  if (argListen) {
    addresses = [argListen];
  } else if (Array.isArray(configListen)) {
    addresses = configListen;
    process.emitWarning('multiple addresses will be deprecated in the next major, only use one');
  } else if (configListen) {
    addresses = [configListen];
  } else {
    addresses = [_constants.DEFAULT_PORT];
  }
  addresses = addresses.map(function (addr) {
    const parsedAddr = (0, _utils.parseAddress)(addr);
    if (!parsedAddr) {
      logger.logger.warn({
        addr: addr
      }, 'invalid address - @{addr}, we expect a port (e.g. "4873"),' + ' host:port (e.g. "localhost:4873") or full url' + ' (e.g. "http://localhost:4873/")');
    }
    return parsedAddr;
  }).filter(Boolean);
  return addresses;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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