"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InitCommand = exports.DEFAULT_PROCESS_NAME = void 0;
var _clipanion = require("clipanion");
var _path = _interopRequireDefault(require("path"));
var _core = require("@verdaccio/core");
var _bootstrap = require("../../bootstrap");
var _configPath = _interopRequireDefault(require("../../config-path"));
var _utils = require("../../utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
require('pkginfo')(module);
const pkgVersion = module.exports.version;
const pkgName = module.exports.name;
const DEFAULT_PROCESS_NAME = 'verdaccio';
exports.DEFAULT_PROCESS_NAME = DEFAULT_PROCESS_NAME;
const logger = require('../../logger');
class InitCommand extends _clipanion.Command {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "listen", _clipanion.Option.String('-l,--listen', {
      description: 'host:port number to listen on (default: localhost:4873)'
    }));
    _defineProperty(this, "config", _clipanion.Option.String('-c,--config', {
      description: 'use this configuration file (default: ./config.yaml)'
    }));
  }
  initLogger(logConfig) {
    if (logConfig.logs) {
      // @ts-expect-error
      logConfig.log = logConfig.logs;
      _core.warningUtils.emit(_core.warningUtils.Codes.VERWAR002);
    }
    // @ts-expect-error
    logger.setup(logConfig.log);
  }
  async execute() {
    let configPathLocation;
    try {
      configPathLocation = (0, _configPath.default)(this.config);
      const configParsed = (0, _utils.parseConfigFile)(configPathLocation);
      if (!configParsed.self_path) {
        configParsed.self_path = _path.default.resolve(configPathLocation);
        this.initLogger(configParsed);
        // compatibility with 6.x plugins
        configParsed.configPath = configParsed.self_path;
      }
      if (!configParsed.https) {
        configParsed.https = {
          enable: false
        };
      }
      process.title = configParsed.web && configParsed.web.title || 'verdaccio';
      (0, _bootstrap.startVerdaccio)(configParsed, this.listen, configPathLocation, pkgVersion, pkgName, _bootstrap.listenDefaultCallback);
      logger.logger.info({
        file: configPathLocation
      }, 'config file  - @{file}');
    } catch (err) {
      var _logger$logger;
      if (typeof (logger === null || logger === void 0 ? void 0 : (_logger$logger = logger.logger) === null || _logger$logger === void 0 ? void 0 : _logger$logger.fatal) === 'function') {
        logger.logger.fatal({
          file: configPathLocation,
          err: err
        }, 'cannot open config file @{file}: @{!err.message}');
      } else {
        // eslint-disable-next-line no-console
        console.error(`cannot open config file ${configPathLocation}: ${!err.message}`);
      }
      process.exit(1);
    }
  }
}
exports.InitCommand = InitCommand;
_defineProperty(InitCommand, "paths", [_clipanion.Command.Default]);
_defineProperty(InitCommand, "usage", _clipanion.Command.Usage({
  description: `launch the server`,
  details: `
      This start the registry in the default port.

      When used without arguments, it:

      - bootstrap the server at the port  \`4873\`

      The optional arguments are:

      - \`--listen\` to switch the default server port,
      - \`--config\` to define a different configuration path location,

    `,
  examples: [[`Runs the server with the default configuration`, `verdaccio`], [`Runs the server in the port 5000`, `verdaccio --listen 5000`], [`Runs the server by using a different absolute location of the configuration file`, `verdaccio --config /home/user/verdaccio/config.yaml`]]
}));
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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