"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfoCommand = void 0;
var _clipanion = require("clipanion");
var _envinfo = _interopRequireDefault(require("envinfo"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
class InfoCommand extends _clipanion.Command {
  async execute() {
    this.context.stdout.write('\nEnvironment Info:');
    const data = await _envinfo.default.run({
      System: ['OS', 'CPU'],
      Binaries: ['node', 'yarn', 'npm', 'pnpm'],
      Virtualization: ['Docker'],
      Browsers: ['Chrome', 'Edge', 'Firefox', 'Safari'],
      npmGlobalPackages: ['verdaccio']
    });
    this.context.stdout.write(data);
    process.exit(0);
  }
}
exports.InfoCommand = InfoCommand;
_defineProperty(InfoCommand, "paths", [[`--info`], [`-i`]]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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