"use strict";

var _clipanion = require("clipanion");
var _info = require("./commands/info");
var _init = require("./commands/init");
var _version = require("./commands/version");
var _utils = require("./utils");
require('pkginfo')(module);
const pkgVersion = module.exports.version;
if (process.getuid && process.getuid() === 0) {
  process.emitWarning(`Verdaccio doesn't need superuser privileges. don't run it under root`);
}
if (!(0, _utils.isVersionValid)(process.version)) {
  throw new Error(`Verdaccio requires at least Node.js v${_utils.MIN_NODE_VERSION} or higher and you have installed ${process.version}, 
    please upgrade your Node.js distribution`);
}
const [node, app, ...args] = process.argv;
const cli = new _clipanion.Cli({
  binaryLabel: `verdaccio`,
  binaryName: `${node} ${app}`,
  binaryVersion: pkgVersion
});
cli.register(_info.InfoCommand);
cli.register(_init.InitCommand);
cli.register(_version.VersionCommand);
cli.runExit(args, _clipanion.Cli.defaultContext);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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