#!/usr/bin/env node

/* eslint no-sync:0 */
/* eslint no-empty:0 */
"use strict";

if (process.getuid && process.getuid() === 0) {
  process.emitWarning(`Verdaccio doesn't need superuser privileges. don't run it under root`);
}

// eslint-disable-next-line import/order
const logger = require('./logger');
require('./cli/cli');
process.on('uncaughtException', function (err) {
  var _logger$logger;
  logger === null || logger === void 0 ? void 0 : (_logger$logger = logger.logger) === null || _logger$logger === void 0 ? void 0 : _logger$logger.fatal({
    err: err
  }, 'uncaught exception, please report this\n@{err.stack}');
  process.exit(255);
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJwcm9jZXNzIiwiZ2V0dWlkIiwiZW1pdFdhcm5pbmciLCJsb2dnZXIiLCJyZXF1aXJlIiwib24iLCJlcnIiLCJfbG9nZ2VyJGxvZ2dlciIsImZhdGFsIiwiZXhpdCJdLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9saWIvY2xpLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIiMhL3Vzci9iaW4vZW52IG5vZGVcblxuLyogZXNsaW50IG5vLXN5bmM6MCAqL1xuLyogZXNsaW50IG5vLWVtcHR5OjAgKi9cblxuaWYgKHByb2Nlc3MuZ2V0dWlkICYmIHByb2Nlc3MuZ2V0dWlkKCkgPT09IDApIHtcbiAgcHJvY2Vzcy5lbWl0V2FybmluZyhgVmVyZGFjY2lvIGRvZXNuJ3QgbmVlZCBzdXBlcnVzZXIgcHJpdmlsZWdlcy4gZG9uJ3QgcnVuIGl0IHVuZGVyIHJvb3RgKTtcbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGltcG9ydC9vcmRlclxuY29uc3QgbG9nZ2VyID0gcmVxdWlyZSgnLi9sb2dnZXInKTtcblxucmVxdWlyZSgnLi9jbGkvY2xpJyk7XG5cbnByb2Nlc3Mub24oJ3VuY2F1Z2h0RXhjZXB0aW9uJywgZnVuY3Rpb24gKGVycikge1xuICBsb2dnZXI/LmxvZ2dlcj8uZmF0YWwoXG4gICAge1xuICAgICAgZXJyOiBlcnIsXG4gICAgfSxcbiAgICAndW5jYXVnaHQgZXhjZXB0aW9uLCBwbGVhc2UgcmVwb3J0IHRoaXNcXG5Ae2Vyci5zdGFja30nXG4gICk7XG4gIHByb2Nlc3MuZXhpdCgyNTUpO1xufSk7XG4iXSwibWFwcGluZ3MiOiJBQUFBOztBQUVBO0FBQ0E7QUFBQTs7QUFFQSxJQUFJQSxPQUFPLENBQUNDLE1BQU0sSUFBSUQsT0FBTyxDQUFDQyxNQUFNLEVBQUUsS0FBSyxDQUFDLEVBQUU7RUFDNUNELE9BQU8sQ0FBQ0UsV0FBVyxDQUFFLHNFQUFxRSxDQUFDO0FBQzdGOztBQUVBO0FBQ0EsTUFBTUMsTUFBTSxHQUFHQyxPQUFPLENBQUMsVUFBVSxDQUFDO0FBRWxDQSxPQUFPLENBQUMsV0FBVyxDQUFDO0FBRXBCSixPQUFPLENBQUNLLEVBQUUsQ0FBQyxtQkFBbUIsRUFBRSxVQUFVQyxHQUFHLEVBQUU7RUFBQSxJQUFBQyxjQUFBO0VBQzdDSixNQUFNLGFBQU5BLE1BQU0sd0JBQUFJLGNBQUEsR0FBTkosTUFBTSxDQUFFQSxNQUFNLGNBQUFJLGNBQUEsdUJBQWRBLGNBQUEsQ0FBZ0JDLEtBQUssQ0FDbkI7SUFDRUYsR0FBRyxFQUFFQTtFQUNQLENBQUMsRUFDRCxzREFBc0QsQ0FDdkQ7RUFDRE4sT0FBTyxDQUFDUyxJQUFJLENBQUMsR0FBRyxDQUFDO0FBQ25CLENBQUMsQ0FBQyJ9