/// <reference types="node" />
import { AuthPluginPackage, Callback, Config, IPluginAuth, JWTSignOptions, Logger, RemoteUser } from '@verdaccio/types';
import { IAuth } from '../types';
declare class Auth implements IAuth {
    config: Config;
    logger: Logger;
    secret: string;
    plugins: IPluginAuth<Config>[];
    constructor(config: Config);
    private _loadPlugin;
    private _applyDefaultPlugins;
    changePassword(username: string, password: string, // pragma: allowlist secret
    newPassword: string, // pragma: allowlist secret
    cb: Callback): void;
    authenticate(username: string, password: string, cb: Callback): void;
    add_user(user: string, password: string, cb: Callback): void;
    /**
     * Allow user to access a package.
     */
    allow_access({ packageName, packageVersion }: AuthPluginPackage, user: RemoteUser, callback: Callback): void;
    allow_unpublish({ packageName, packageVersion }: AuthPluginPackage, user: RemoteUser, callback: Callback): void;
    /**
     * Allow user to publish a package.
     */
    allow_publish({ packageName, packageVersion }: AuthPluginPackage, user: RemoteUser, callback: Callback): void;
    apiJWTmiddleware(): Function;
    private _handleJWTAPIMiddleware;
    private _handleAESMiddleware;
    private _isRemoteUserValid;
    /**
     * JWT middleware for WebUI
     */
    webUIJWTmiddleware(): Function;
    jwtEncrypt(user: RemoteUser, signOptions: JWTSignOptions): Promise<string>;
    /**
     * Encrypt a string.
     */
    aesEncrypt(buf: Buffer): Buffer;
}
export default Auth;
