import { Config, IPluginAuth, RemoteUser, Security } from '@verdaccio/types';
import { AuthMiddlewarePayload, AuthTokenHeader, BasicPayload, IAuthWebUI } from '../types';
export declare function validatePassword(password: string, // pragma: allowlist secret
minLength?: number): boolean;
export declare function allow_action(action: string): Function;
/**
 *
 */
export declare function handleSpecialUnpublish(): any;
export declare function getDefaultPlugins(logger: any): IPluginAuth<Config>;
export declare const defaultSecurity: Security;
export declare function getSecurity(config: Config): Security;
export declare function isAESLegacy(security: Security): boolean;
export declare function getApiToken(auth: IAuthWebUI, config: Config, remoteUser: RemoteUser, aesPassword: string): Promise<string>;
export declare function parseAuthTokenHeader(authorizationHeader: string): AuthTokenHeader;
export declare function parseBasicPayload(credentials: string): BasicPayload;
export declare function parseAESCredentials(authorizationHeader: string, secret: string): string | undefined;
export declare const expireReasons: string[];
export declare function verifyJWTPayload(token: string, secret: string): RemoteUser;
export declare function isAuthHeaderValid(authorization: string): boolean;
export declare function getMiddlewareCredentials(security: Security, secret: string, authorizationHeader: string): AuthMiddlewarePayload;
