"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.loadTheme = loadTheme;
var _debug = _interopRequireDefault(require("debug"));
var _express = _interopRequireDefault(require("express"));
var _lodash = _interopRequireDefault(require("lodash"));
var _middleware = require("@verdaccio/middleware");
var _pluginLoader = _interopRequireDefault(require("../../lib/plugin-loader"));
var _search = _interopRequireDefault(require("../../lib/search"));
var _api = _interopRequireDefault(require("./api"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const debug = (0, _debug.default)('verdaccio:web');
function loadTheme(config) {
  if (_lodash.default.isNil(config.theme) === false) {
    return _lodash.default.head((0, _pluginLoader.default)(config, config.theme, {}, function (plugin) {
      return plugin.staticPath && plugin.manifest && plugin.manifestFiles;
    }, 'verdaccio-theme'));
  }
}
var _default = (config, auth, storage) => {
  const pluginOptions = loadTheme(config) || require('@verdaccio/ui-theme')();
  _search.default.configureStorage(storage);
  // eslint-disable-next-line new-cap
  const router = _express.default.Router();
  // load application
  router.use((0, _middleware.webMiddleware)(config, {
    tokenMiddleware: auth.webUIJWTmiddleware(),
    webEndpointsApi: (0, _api.default)(auth, storage, config)
  }, pluginOptions));
  return router;
};
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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