"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _express = require("express");
var _lodash = _interopRequireDefault(require("lodash"));
var _authUtils = require("../../../lib/auth-utils");
var _constants = require("../../../lib/constants");
var _utils = require("../../../lib/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function addUserAuthApi(auth, config) {
  const route = (0, _express.Router)(); /* eslint new-cap: 0 */
  route.post('/login', function (req, res, next) {
    const {
      username,
      password
    } = req.body;
    auth.authenticate(username, password, async (err, user) => {
      if (err) {
        const errorCode = err.message ? _constants.HTTP_STATUS.UNAUTHORIZED : _constants.HTTP_STATUS.INTERNAL_ERROR;
        next(_utils.ErrorCode.getCode(errorCode, err.message));
      } else {
        req.remote_user = user;
        const jWTSignOptions = (0, _authUtils.getSecurity)(config).web.sign;
        res.set(_constants.HEADERS.CACHE_CONTROL, 'no-cache, no-store');
        next({
          token: await auth.jwtEncrypt(user, jWTSignOptions),
          username: req.remote_user.name
        });
      }
    });
  });
  route.put('/reset_password', function (req, res, next) {
    if (_lodash.default.isNil(req.remote_user.name)) {
      res.status(_constants.HTTP_STATUS.UNAUTHORIZED);
      return next({
        // FUTURE: update to a more meaningful message
        message: _constants.API_ERROR.MUST_BE_LOGGED
      });
    }
    const {
      password
    } = req.body;
    const {
      name
    } = req.remote_user;
    if ((0, _authUtils.validatePassword)(password.new) === false) {
      auth.changePassword(name, password.old, password.new, (err, isUpdated) => {
        if (_lodash.default.isNil(err) && isUpdated) {
          next({
            ok: true
          });
        } else {
          return next(_utils.ErrorCode.getInternalError(_constants.API_ERROR.INTERNAL_SERVER_ERROR));
        }
      });
    } else {
      return next(_utils.ErrorCode.getCode(_constants.HTTP_STATUS.BAD_REQUEST, _constants.APP_ERROR.PASSWORD_VALIDATION));
    }
  });
  return route;
}
var _default = addUserAuthApi;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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