"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _express = require("express");
var _constants = require("../../../lib/constants");
var _search = _interopRequireDefault(require("../../../lib/search"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function addSearchWebApi(storage, auth) {
  const route = (0, _express.Router)(); /* eslint new-cap: 0 */
  // Search package
  route.get('/search/:anything', function (req, res, next) {
    const results = _search.default.query(req.params.anything);
    // FUTURE: figure out here the correct type
    const packages = [];
    const getPackageInfo = function (i) {
      storage.getPackage({
        name: results[i].ref,
        uplinksLook: false,
        callback: (err, entry) => {
          if (!err && entry) {
            auth.allow_access({
              packageName: entry.name
            }, req.remote_user, function (err, allowed) {
              if (err || !allowed) {
                return;
              }
              packages.push(entry.versions[entry[_constants.DIST_TAGS].latest]);
            });
          }
          if (i >= results.length - 1) {
            next(packages);
          } else {
            getPackageInfo(i + 1);
          }
        }
      });
    };
    if (results.length) {
      getPackageInfo(0);
    } else {
      next([]);
    }
  });
  return route;
}
var _default = addSearchWebApi;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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