"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _express = require("express");
var _lodash = _interopRequireDefault(require("lodash"));
var _middleware = require("@verdaccio/middleware");
var _tarball = require("@verdaccio/tarball");
var _utils = require("@verdaccio/utils");
var _constants = require("../../../lib/constants");
var _logger = require("../../../lib/logger");
var _utils2 = require("../../../lib/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
const getOrder = (order = 'asc') => {
  return order === 'asc';
};
function addPackageWebApi(storage, auth, config) {
  const can = (0, _middleware.allow)(auth, {
    beforeAll: (params, message) => {
      _logger.logger.debug(params, message);
    },
    afterAll: (params, message) => _logger.logger.debug(params, message)
  });
  const pkgRouter = (0, _express.Router)(); /* eslint new-cap: 0 */

  const checkAllow = (name, remoteUser) => new Promise((resolve, reject) => {
    try {
      auth.allow_access({
        packageName: name
      }, remoteUser, (err, allowed) => {
        if (err) {
          resolve(false);
        }
        resolve(allowed);
      });
    } catch (err) {
      reject(err);
    }
  });

  // Get list of all visible package
  pkgRouter.get('/packages', function (req, res, next) {
    storage.getLocalDatabase(async function (err, packages) {
      if (err) {
        throw err;
      }
      async function processPackages(packages = []) {
        const permissions = [];
        const packgesCopy = packages.slice();
        for (const pkg of packgesCopy) {
          const pkgCopy = _objectSpread({}, pkg);
          pkgCopy.author = (0, _utils2.formatAuthor)(pkg.author);
          try {
            if (await checkAllow(pkg.name, req.remote_user)) {
              if (config.web) {
                pkgCopy.author.avatar = (0, _utils.generateGravatarUrl)(pkgCopy.author.email, config.web.gravatar);
              }
              if (!_lodash.default.isNil(pkgCopy.dist) && !_lodash.default.isNull(pkgCopy.dist.tarball)) {
                pkgCopy.dist.tarball = (0, _tarball.getLocalRegistryTarballUri)(pkgCopy.dist.tarball, pkg.name, {
                  protocol: req.protocol,
                  headers: req.headers,
                  host: req.hostname
                }, config.url_prefix);
              }
              permissions.push(pkgCopy);
            }
          } catch (err) {
            _logger.logger.error({
              name: pkg.name,
              error: err
            }, 'permission process for @{name} has failed: @{error}');
            throw err;
          }
        }
        return permissions;
      }
      const {
        web
      } = config;
      // @ts-ignore
      const order = config.web ? getOrder(web.sort_packages) : true;
      try {
        next((0, _utils2.sortByName)(await processPackages(packages), order));
      } catch (error) {
        next(_utils2.ErrorCode.getInternalError());
      }
    });
  });

  // Get package readme
  pkgRouter.get('/package/readme/(@:scope/)?:package/:version?', can('access'), function (req, res, next) {
    const packageName = req.params.scope ? (0, _utils2.addScope)(req.params.scope, req.params.package) : req.params.package;
    storage.getPackage({
      name: packageName,
      uplinksLook: true,
      req,
      callback: function (err, info) {
        if (err) {
          return next(err);
        }
        res.set(_constants.HEADER_TYPE.CONTENT_TYPE, _constants.HEADERS.TEXT_PLAIN);
        next((0, _utils2.parseReadme)(info.name, info.readme));
      }
    });
  });
  pkgRouter.get('/sidebar/(@:scope/)?:package', can('access'), function (req, res, next) {
    const packageName = req.params.scope ? (0, _utils2.addScope)(req.params.scope, req.params.package) : req.params.package;
    storage.getPackage({
      name: packageName,
      uplinksLook: true,
      keepUpLinkData: true,
      req,
      callback: function (err, info) {
        if (_lodash.default.isNil(err)) {
          const {
            v
          } = req.query;
          let sideBarInfo = _lodash.default.clone(info);
          sideBarInfo.versions = (0, _tarball.convertDistRemoteToLocalTarballUrls)(info, {
            protocol: req.protocol,
            headers: req.headers,
            host: req.hostname
          }, config.url_prefix).versions;
          if ((0, _utils2.isVersionValid)(info, v)) {
            // @ts-ignore
            sideBarInfo.latest = sideBarInfo.versions[v];
            sideBarInfo.latest.author = (0, _utils2.formatAuthor)(sideBarInfo.latest.author);
          } else {
            var _sideBarInfo;
            sideBarInfo.latest = sideBarInfo.versions[info[_constants.DIST_TAGS].latest];
            if ((_sideBarInfo = sideBarInfo) !== null && _sideBarInfo !== void 0 && _sideBarInfo.latest) {
              sideBarInfo.latest.author = (0, _utils2.formatAuthor)(sideBarInfo.latest.author);
            } else {
              res.status(_constants.HTTP_STATUS.NOT_FOUND);
              res.end();
              return;
            }
          }
          sideBarInfo = (0, _utils2.deleteProperties)(['readme', '_attachments', '_rev', 'name'], sideBarInfo);
          if (config.web) {
            sideBarInfo = (0, _utils2.addGravatarSupport)(sideBarInfo, config.web.gravatar);
          } else {
            sideBarInfo = (0, _utils2.addGravatarSupport)(sideBarInfo);
          }
          next(sideBarInfo);
        } else {
          res.status(_constants.HTTP_STATUS.NOT_FOUND);
          res.end();
        }
      }
    });
  });
  return pkgRouter;
}
var _default = addPackageWebApi;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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