"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _express = require("express");
var _middleware = require("@verdaccio/middleware");
var _utils = require("../../../lib/utils");
var _package = _interopRequireDefault(require("./package"));
var _search = _interopRequireDefault(require("./search"));
var _user = _interopRequireDefault(require("./user"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var _default = (auth, storage, config) => {
  var _config$web;
  const route = (0, _express.Router)(); /* eslint new-cap: 0 */
  route.use('/data/', (0, _middleware.rateLimit)(_objectSpread({
    windowMs: 2 * 60 * 1000,
    // 2  minutes
    max: 5000
  }, config === null || config === void 0 ? void 0 : (_config$web = config.web) === null || _config$web === void 0 ? void 0 : _config$web.rateLimit)));
  route.use('/data/', (0, _package.default)(storage, auth, config));
  route.use('/data/', (0, _search.default)(storage, auth));
  route.use('/sec/', (0, _middleware.rateLimit)(config === null || config === void 0 ? void 0 : config.userRateLimit));
  if ((0, _utils.hasLogin)(config)) {
    route.use('/sec/', (0, _user.default)(auth, storage));
  }
  return route;
};
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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