"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _express = _interopRequireDefault(require("express"));
var _distTags = _interopRequireDefault(require("./api/dist-tags"));
var _package = _interopRequireDefault(require("./api/package"));
var _ping = _interopRequireDefault(require("./api/ping"));
var _publish = _interopRequireDefault(require("./api/publish"));
var _search = _interopRequireDefault(require("./api/search"));
var _stars = _interopRequireDefault(require("./api/stars"));
var _user = _interopRequireDefault(require("./api/user"));
var _v = _interopRequireDefault(require("./api/v1"));
var _search2 = _interopRequireDefault(require("./api/v1/search"));
var _whoami = _interopRequireDefault(require("./api/whoami"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const {
  match,
  validateName,
  validatePackage,
  encodeScopePackage,
  antiLoop
} = require('@verdaccio/middleware');
function _default(config, auth, storage) {
  /* eslint new-cap:off */
  const app = _express.default.Router();
  /* eslint new-cap:off */
  // validate all of these params as a package name
  // this might be too harsh, so ask if it causes trouble
  app.param('package', validatePackage);
  app.param('filename', validateName);
  app.param('tag', validateName);
  app.param('version', validateName);
  app.param('revision', validateName);
  app.param('token', validateName);

  // these can't be safely put into express url for some reason
  // TODO: For some reason? what reason?
  app.param('_rev', match(/^-rev$/));
  app.param('org_couchdb_user', match(/^org\.couchdb\.user:/));
  app.use(auth.apiJWTmiddleware());
  app.use(_express.default.json({
    strict: false,
    limit: config.max_body_size || '10mb'
  }));
  app.use(antiLoop(config));
  // encode / in a scoped package name to be matched as a single parameter in routes
  app.use(encodeScopePackage);
  // for "npm whoami"
  (0, _whoami.default)(app);
  (0, _package.default)(app, auth, storage, config);
  (0, _search.default)(app, auth, storage);
  (0, _distTags.default)(app, auth, storage);
  (0, _publish.default)(app, auth, storage, config);
  (0, _ping.default)(app);
  (0, _stars.default)(app, storage);
  (0, _search2.default)(app, auth, storage);
  (0, _user.default)(app, auth, config);
  app.use((0, _v.default)(auth, storage, config));
  return app;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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