"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _express = require("express");
var _lodash = _interopRequireDefault(require("lodash"));
var _middleware = require("@verdaccio/middleware");
var _authUtils = require("../../../../lib/auth-utils");
var _constants = require("../../../../lib/constants");
var _utils = require("../../../../lib/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _default(auth, config) {
  const profileRoute = (0, _express.Router)(); /* eslint new-cap: 0 */
  function buildProfile(name) {
    return {
      tfa: false,
      name,
      email: '',
      email_verified: false,
      created: '',
      updated: '',
      cidr_whitelist: null,
      fullname: ''
    };
  }
  profileRoute.get('/user', (0, _middleware.rateLimit)(config === null || config === void 0 ? void 0 : config.userRateLimit), function (req, res, next) {
    if (_lodash.default.isNil(req.remote_user.name) === false) {
      return next(buildProfile(req.remote_user.name));
    }
    res.status(_constants.HTTP_STATUS.UNAUTHORIZED);
    return next({
      message: _constants.API_ERROR.MUST_BE_LOGGED
    });
  });
  profileRoute.post('/user', (0, _middleware.rateLimit)(config === null || config === void 0 ? void 0 : config.userRateLimit), function (req, res, next) {
    if (_lodash.default.isNil(req.remote_user.name)) {
      res.status(_constants.HTTP_STATUS.UNAUTHORIZED);
      return next({
        message: _constants.API_ERROR.MUST_BE_LOGGED
      });
    }
    const {
      password,
      tfa
    } = req.body;
    const {
      name
    } = req.remote_user;
    if (_lodash.default.isNil(password) === false) {
      if ((0, _authUtils.validatePassword)(password.new) === false) {
        /* eslint new-cap:off */
        return next(_utils.ErrorCode.getCode(_constants.HTTP_STATUS.UNAUTHORIZED, _constants.API_ERROR.PASSWORD_SHORT));
        /* eslint new-cap:off */
      }

      auth.changePassword(name, password.old, password.new, (err, isUpdated) => {
        if (_lodash.default.isNull(err) === false) {
          return next(_utils.ErrorCode.getCode(err.status, err.message) || _utils.ErrorCode.getConflict(err.message));
        }
        if (isUpdated) {
          return next(buildProfile(req.remote_user.name));
        }
        return next(_utils.ErrorCode.getInternalError(_constants.API_ERROR.INTERNAL_SERVER_ERROR));
      });
    } else if (_lodash.default.isNil(tfa) === false) {
      return next(_utils.ErrorCode.getCode(_constants.HTTP_STATUS.SERVICE_UNAVAILABLE, _constants.SUPPORT_ERRORS.TFA_DISABLED));
    } else {
      return next(_utils.ErrorCode.getCode(_constants.HTTP_STATUS.INTERNAL_ERROR, _constants.APP_ERROR.PROFILE_ERROR));
    }
  });
  return profileRoute;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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