"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _cookies = _interopRequireDefault(require("cookies"));
var _express = _interopRequireDefault(require("express"));
var _lodash = _interopRequireDefault(require("lodash"));
var _config = require("@verdaccio/config");
var _middleware = require("@verdaccio/middleware");
var _utils = require("@verdaccio/utils");
var _authUtils = require("../../../lib/auth-utils");
var _constants = require("../../../lib/constants");
var _logger = require("../../../lib/logger");
var _utils2 = require("../../../lib/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _default(route, auth, config) {
  /* eslint new-cap:off */
  const userRouter = _express.default.Router();
  userRouter.get('/-/user/:org_couchdb_user', (0, _middleware.rateLimit)(config === null || config === void 0 ? void 0 : config.userRateLimit), function (req, res, next) {
    res.status(_constants.HTTP_STATUS.OK);
    next({
      ok: (0, _utils.getAuthenticatedMessage)(req.remote_user.name)
    });
  });
  userRouter.put('/-/user/:org_couchdb_user/:_rev?/:revision?', (0, _middleware.rateLimit)(config === null || config === void 0 ? void 0 : config.userRateLimit), function (req, res, next) {
    const {
      name,
      password
    } = req.body;
    const remoteName = req.remote_user.name;
    if (_lodash.default.isNil(remoteName) === false && _lodash.default.isNil(name) === false && remoteName === name) {
      auth.authenticate(name, password, async function callbackAuthenticate(err, user) {
        if (err) {
          _logger.logger.error({
            name,
            err
          }, 'authenticating for user @{username} failed. Error: @{err.message}');
          return next(_utils2.ErrorCode.getCode(_constants.HTTP_STATUS.UNAUTHORIZED, _constants.API_ERROR.BAD_USERNAME_PASSWORD));
        }
        const restoredRemoteUser = (0, _config.createRemoteUser)(name, user.groups || []);
        const token = await (0, _authUtils.getApiToken)(auth, config, restoredRemoteUser, password);
        res.status(_constants.HTTP_STATUS.CREATED);
        res.set(_constants.HEADERS.CACHE_CONTROL, 'no-cache, no-store');
        return next({
          ok: (0, _utils.getAuthenticatedMessage)(req.remote_user.name),
          token
        });
      });
    } else {
      if ((0, _authUtils.validatePassword)(password) === false) {
        // eslint-disable-next-line new-cap
        return next(_utils2.ErrorCode.getCode(_constants.HTTP_STATUS.BAD_REQUEST, _constants.API_ERROR.PASSWORD_SHORT));
      }
      auth.add_user(name, password, async function (err, user) {
        if (err) {
          if (err.status >= _constants.HTTP_STATUS.BAD_REQUEST && err.status < _constants.HTTP_STATUS.INTERNAL_ERROR) {
            // With npm registering is the same as logging in,
            // and npm accepts only an 409 error.
            // So, changing status code here.
            return next(_utils2.ErrorCode.getCode(err.status, err.message) || _utils2.ErrorCode.getConflict(err.message));
          }
          return next(err);
        }
        const token = name && password ? await (0, _authUtils.getApiToken)(auth, config, user, password) : undefined;
        req.remote_user = user;
        res.status(_constants.HTTP_STATUS.CREATED);
        res.set(_constants.HEADERS.CACHE_CONTROL, 'no-cache, no-store');
        return next({
          ok: `user '${req.body.name}' created`,
          token
        });
      });
    }
  });
  userRouter.delete('/-/user/token/*', (0, _middleware.rateLimit)(config === null || config === void 0 ? void 0 : config.userRateLimit), function (req, res, next) {
    res.status(_constants.HTTP_STATUS.OK);
    next({
      ok: _constants.API_MESSAGE.LOGGED_OUT
    });
  });

  // placeholder 'cause npm require to be authenticated to publish
  // we do not do any real authentication yet
  userRouter.post('/_session', _cookies.default.express(), function (req, res, next) {
    res.cookies.set('AuthSession', String(Math.random()), (0, _utils.createSessionToken)());
    next({
      ok: true,
      name: 'somebody',
      roles: []
    });
  });
  route.use(userRouter);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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