"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _lodash = _interopRequireDefault(require("lodash"));
var _core = require("@verdaccio/core");
var _constants = require("../../../lib/constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _default(route, storage) {
  route.get('/-/_view/starredByUser', (req, res, next) => {
    // @ts-ignore
    const query = req.query;
    if (typeof (query === null || query === void 0 ? void 0 : query.key) !== 'string') {
      return next(_core.errorUtils.getBadRequest('missing query key username'));
    }

    // @ts-ignore
    storage.getLocalDatabase((err, localPackages) => {
      if (err) {
        return next(err);
      }
      const filteredPackages = localPackages.filter(localPackage => _lodash.default.keys(localPackage[_constants.USERS]).includes(query === null || query === void 0 ? void 0 : query.key.toString().replace(/['"]+/g, '')));
      res.status(_constants.HTTP_STATUS.OK);
      next({
        rows: filteredPackages.map(filteredPackage => ({
          value: filteredPackage.name
        }))
      });
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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