"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _debug = _interopRequireDefault(require("debug"));
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("../../../lib/constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
const debug = (0, _debug.default)('verdaccio:star');
function _default(storage) {
  const validateInputs = (newUsers, localUsers, username, isStar) => {
    const isExistlocalUsers = _lodash.default.isNil(localUsers[username]) === false;
    if (isStar && isExistlocalUsers && localUsers[username]) {
      return true;
    } else if (!isStar && isExistlocalUsers) {
      return false;
    } else if (!isStar && !isExistlocalUsers) {
      return true;
    }
    return false;
  };
  return (req, res, next) => {
    const name = req.params.package;
    debug('starring a package for %o', name);
    const afterChangePackage = function (err) {
      if (err) {
        return next(err);
      }
      res.status(_constants.HTTP_STATUS.OK);
      next({
        success: true
      });
    };
    storage.getPackage({
      name,
      req,
      callback: function (err, info) {
        if (err) {
          return next(err);
        }
        const newStarUser = req.body[_constants.USERS];
        const remoteUsername = req.remote_user.name;
        const localStarUsers = info[_constants.USERS];
        // Check is star or unstar
        const isStar = Object.keys(newStarUser).includes(remoteUsername);
        if (_lodash.default.isNil(localStarUsers) === false && validateInputs(newStarUser, localStarUsers, remoteUsername, isStar)) {
          return afterChangePackage();
        }
        const users = isStar ? _objectSpread(_objectSpread({}, localStarUsers), {}, {
          [remoteUsername]: true
        }) : _lodash.default.reduce(localStarUsers, (users, value, key) => {
          if (key !== remoteUsername) {
            users[key] = value;
          }
          return users;
        }, {});
        storage.changePackage(name, _objectSpread(_objectSpread({}, info), {}, {
          users
        }), req.body._rev, function (err) {
          afterChangePackage(err);
        });
      }
    });
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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