"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _constants = require("../../../lib/constants");
var _logger = require("../../../lib/logger");
function _default(route, auth, storage) {
  // searching packages
  route.get('/-/all(/since)?', function (req, res, next) {
    let received_end = false;
    let response_finished = false;
    let processing_pkgs = 0;
    let firstPackage = true;
    _logger.logger.warn('/-/all search endpoint is deprecated, might be removed in the next major release');
    res.status(200);
    res.set(_constants.HEADERS.CONTENT_TYPE, _constants.HEADERS.JSON_CHARSET);

    /*
     * Offical NPM registry (registry.npmjs.org) no longer return whole database,
     * They only return packages matched with keyword in `referer: search pkg-name`,
     * And NPM client will request server in every search.
     *
     * The magic number 99999 was sent by NPM registry. Modify it may caused strange
     * behaviour in the future.
     *
     * BTW: NPM will not return result if user-agent does not contain string 'npm',
     * See: method 'request' in up-storage.js
     *
     * If there is no cache in local, NPM will request /-/all, then get response with
     * _updated: 99999, 'Date' in response header was Mon, 10 Oct 1983 00:12:48 GMT,
     * this will make NPM always query from server
     *
     * Data structure also different, whel request /-/all, response is an object, but
     * when request /-/all/since, response is an array
     */
    const respShouldBeArray = req.path.endsWith('/since');
    if (!respShouldBeArray) {
      res.set('Date', 'Mon, 10 Oct 1983 00:12:48 GMT');
    }
    const check_finish = function () {
      if (!received_end) {
        return;
      }
      if (processing_pkgs) {
        return;
      }
      if (response_finished) {
        return;
      }
      response_finished = true;
      if (respShouldBeArray) {
        res.end(']\n');
      } else {
        res.end('}\n');
      }
    };
    if (respShouldBeArray) {
      res.write('[');
    } else {
      res.write('{"_updated":' + 99999);
    }
    const stream = storage.search(req.query.startkey || 0, {
      req: req
    });
    stream.on('data', function each(pkg) {
      processing_pkgs++;
      auth.allow_access({
        packageName: pkg.name
      }, req.remote_user, function (err, allowed) {
        processing_pkgs--;
        if (err) {
          if (err.status && String(err.status).match(/^4\d\d$/)) {
            // auth plugin returns 4xx user error,
            // that's equivalent of !allowed basically
            allowed = false;
          } else {
            stream.abort(err);
          }
        }
        if (allowed) {
          if (respShouldBeArray) {
            res.write(`${firstPackage ? '' : ','}${JSON.stringify(pkg)}\n`);
            if (firstPackage) {
              firstPackage = false;
            }
          } else {
            res.write(',\n' + JSON.stringify(pkg.name) + ':' + JSON.stringify(pkg));
          }
        }
        check_finish();
      });
    });
    stream.on('error', function (err) {
      _logger.logger.error('search `/-/all endpoint has failed @{err}', err);
      received_end = true;
      check_finish();
    });
    stream.on('end', function () {
      received_end = true;
      check_finish();
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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