import { Router } from 'express';
import { Config } from '@verdaccio/types';
import { $NextFunctionVer, $RequestExtend, $ResponseExtend, IAuth, IStorageHandler } from '../../../types';
export default function publish(router: Router, auth: IAuth, storage: IStorageHandler, config: Config): void;
/**
 * Publish a package
 */
export declare function publishPackage(storage: IStorageHandler, config: Config, auth: IAuth): any;
/**
 * un-publish a package
 */
export declare function unPublishPackage(storage: IStorageHandler): (req: $RequestExtend, res: $ResponseExtend, next: $NextFunctionVer) => void;
/**
 * Delete tarball
 */
export declare function removeTarball(storage: IStorageHandler): (req: $RequestExtend, res: $ResponseExtend, next: $NextFunctionVer) => void;
/**
 * Adds a new version
 */
export declare function addVersion(storage: IStorageHandler): (req: $RequestExtend, res: $ResponseExtend, next: $NextFunctionVer) => void;
/**
 * uploadPackageTarball
 */
export declare function uploadPackageTarball(storage: IStorageHandler): (req: $RequestExtend, res: $ResponseExtend, next: $NextFunctionVer) => void;
