"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _lodash = _interopRequireDefault(require("lodash"));
var _mime = _interopRequireDefault(require("mime"));
var _middleware = require("@verdaccio/middleware");
var _constants = require("../../../lib/constants");
var _logger = require("../../../lib/logger");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _default(route, auth, storage) {
  const can = (0, _middleware.allow)(auth, {
    beforeAll: (params, message) => _logger.logger.trace(params, message),
    afterAll: (params, message) => _logger.logger.trace(params, message)
  });
  const tag_package_version = function (req, res, next) {
    if (_lodash.default.isString(req.body) === false) {
      return next('route');
    }
    const tags = {};
    tags[req.params.tag] = req.body;
    storage.mergeTags(req.params.package, tags, function (err) {
      if (err) {
        return next(err);
      }
      res.status(_constants.HTTP_STATUS.CREATED);
      return next({
        ok: _constants.API_MESSAGE.TAG_ADDED
      });
    });
  };

  // tagging a package
  route.put('/:package/:tag', can('publish'), (0, _middleware.media)(_mime.default.getType('json')), tag_package_version);
  route.post('/-/package/:package/dist-tags/:tag', can('publish'), (0, _middleware.media)(_mime.default.getType('json')), tag_package_version);
  route.put('/-/package/:package/dist-tags/:tag', can('publish'), (0, _middleware.media)(_mime.default.getType('json')), tag_package_version);
  route.delete('/-/package/:package/dist-tags/:tag', can('publish'), function (req, res, next) {
    const tags = {};
    tags[req.params.tag] = null;
    storage.mergeTags(req.params.package, tags, function (err) {
      if (err) {
        return next(err);
      }
      res.status(_constants.HTTP_STATUS.CREATED);
      return next({
        ok: _constants.API_MESSAGE.TAG_REMOVED
      });
    });
  });
  route.get('/-/package/:package/dist-tags', can('access'), function (req, res, next) {
    storage.getPackage({
      name: req.params.package,
      uplinksLook: true,
      req,
      callback: function (err, info) {
        if (err) {
          return next(err);
        }
        next(info[_constants.DIST_TAGS]);
      }
    });
  });
  route.post('/-/package/:package/dist-tags', can('publish'), function (req, res, next) {
    storage.mergeTags(req.params.package, req.body, function (err) {
      if (err) {
        return next(err);
      }
      res.status(_constants.HTTP_STATUS.CREATED);
      return next({
        ok: _constants.API_MESSAGE.TAG_UPDATED
      });
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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