"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParserConfiguration = exports.ConfigurationHandler = exports.Configuration = void 0;
var Options_js_1 = require("../../util/Options.js");
var MapHandler_js_1 = require("./MapHandler.js");
var FunctionList_js_1 = require("../../util/FunctionList.js");
var PrioritizedList_js_1 = require("../../util/PrioritizedList.js");
var Tags_js_1 = require("./Tags.js");
var Configuration = (function () {
    function Configuration(name, handler, fallback, items, tags, options, nodes, preprocessors, postprocessors, initMethod, configMethod, priority, parser) {
        if (handler === void 0) { handler = {}; }
        if (fallback === void 0) { fallback = {}; }
        if (items === void 0) { items = {}; }
        if (tags === void 0) { tags = {}; }
        if (options === void 0) { options = {}; }
        if (nodes === void 0) { nodes = {}; }
        if (preprocessors === void 0) { preprocessors = []; }
        if (postprocessors === void 0) { postprocessors = []; }
        if (initMethod === void 0) { initMethod = null; }
        if (configMethod === void 0) { configMethod = null; }
        this.name = name;
        this.handler = handler;
        this.fallback = fallback;
        this.items = items;
        this.tags = tags;
        this.options = options;
        this.nodes = nodes;
        this.preprocessors = preprocessors;
        this.postprocessors = postprocessors;
        this.initMethod = initMethod;
        this.configMethod = configMethod;
        this.priority = priority;
        this.parser = parser;
        this.handler = Object.assign({ character: [], delimiter: [], macro: [], environment: [] }, handler);
    }
    Configuration.makeProcessor = function (func, priority) {
        return Array.isArray(func) ? func : [func, priority];
    };
    Configuration._create = function (name, config) {
        var _this = this;
        if (config === void 0) { config = {}; }
        var priority = config.priority || PrioritizedList_js_1.PrioritizedList.DEFAULTPRIORITY;
        var init = config.init ? this.makeProcessor(config.init, priority) : null;
        var conf = config.config ? this.makeProcessor(config.config, priority) : null;
        var preprocessors = (config.preprocessors || []).map(function (pre) { return _this.makeProcessor(pre, priority); });
        var postprocessors = (config.postprocessors || []).map(function (post) { return _this.makeProcessor(post, priority); });
        var parser = config.parser || 'tex';
        return new Configuration(name, config.handler || {}, config.fallback || {}, config.items || {}, config.tags || {}, config.options || {}, config.nodes || {}, preprocessors, postprocessors, init, conf, priority, parser);
    };
    Configuration.create = function (name, config) {
        if (config === void 0) { config = {}; }
        var configuration = Configuration._create(name, config);
        ConfigurationHandler.set(name, configuration);
        return configuration;
    };
    Configuration.local = function (config) {
        if (config === void 0) { config = {}; }
        return Configuration._create('', config);
    };
    Object.defineProperty(Configuration.prototype, "init", {
        get: function () {
            return this.initMethod ? this.initMethod[0] : null;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Configuration.prototype, "config", {
        get: function () {
            return this.configMethod ? this.configMethod[0] : null;
        },
        enumerable: false,
        configurable: true
    });
    return Configuration;
}());
exports.Configuration = Configuration;
var ConfigurationHandler;
(function (ConfigurationHandler) {
    var maps = new Map();
    ConfigurationHandler.set = function (name, map) {
        maps.set(name, map);
    };
    ConfigurationHandler.get = function (name) {
        return maps.get(name);
    };
    ConfigurationHandler.keys = function () {
        return maps.keys();
    };
})(ConfigurationHandler = exports.ConfigurationHandler || (exports.ConfigurationHandler = {}));
var ParserConfiguration = (function () {
    function ParserConfiguration(packages, parsers) {
        var e_1, _a, e_2, _b;
        if (parsers === void 0) { parsers = ['tex']; }
        this.initMethod = new FunctionList_js_1.FunctionList();
        this.configMethod = new FunctionList_js_1.FunctionList();
        this.configurations = new PrioritizedList_js_1.PrioritizedList();
        this.parsers = [];
        this.handlers = new MapHandler_js_1.SubHandlers();
        this.items = {};
        this.tags = {};
        this.options = {};
        this.nodes = {};
        this.parsers = parsers;
        try {
            for (var _c = __values(packages.slice().reverse()), _d = _c.next(); !_d.done; _d = _c.next()) {
                var pkg = _d.value;
                this.addPackage(pkg);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_1) throw e_1.error; }
        }
        try {
            for (var _e = __values(this.configurations), _f = _e.next(); !_f.done; _f = _e.next()) {
                var _g = _f.value, config = _g.item, priority = _g.priority;
                this.append(config, priority);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    ParserConfiguration.prototype.init = function () {
        this.initMethod.execute(this);
    };
    ParserConfiguration.prototype.config = function (jax) {
        var e_3, _a;
        this.configMethod.execute(this, jax);
        try {
            for (var _b = __values(this.configurations), _c = _b.next(); !_c.done; _c = _b.next()) {
                var config = _c.value;
                this.addFilters(jax, config.item);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
    };
    ParserConfiguration.prototype.addPackage = function (pkg) {
        var name = typeof pkg === 'string' ? pkg : pkg[0];
        var conf = this.getPackage(name);
        conf && this.configurations.add(conf, typeof pkg === 'string' ? conf.priority : pkg[1]);
    };
    ParserConfiguration.prototype.add = function (name, jax, options) {
        var e_4, _a;
        if (options === void 0) { options = {}; }
        var config = this.getPackage(name);
        this.append(config);
        this.configurations.add(config, config.priority);
        this.init();
        var parser = jax.parseOptions;
        parser.nodeFactory.setCreators(config.nodes);
        try {
            for (var _b = __values(Object.keys(config.items)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var kind = _c.value;
                parser.itemFactory.setNodeClass(kind, config.items[kind]);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
        Tags_js_1.TagsFactory.addTags(config.tags);
        (0, Options_js_1.defaultOptions)(parser.options, config.options);
        (0, Options_js_1.userOptions)(parser.options, options);
        this.addFilters(jax, config);
        if (config.config) {
            config.config(this, jax);
        }
    };
    ParserConfiguration.prototype.getPackage = function (name) {
        var config = ConfigurationHandler.get(name);
        if (config && this.parsers.indexOf(config.parser) < 0) {
            throw Error("Package ".concat(name, " doesn't target the proper parser"));
        }
        return config;
    };
    ParserConfiguration.prototype.append = function (config, priority) {
        priority = priority || config.priority;
        if (config.initMethod) {
            this.initMethod.add(config.initMethod[0], config.initMethod[1]);
        }
        if (config.configMethod) {
            this.configMethod.add(config.configMethod[0], config.configMethod[1]);
        }
        this.handlers.add(config.handler, config.fallback, priority);
        Object.assign(this.items, config.items);
        Object.assign(this.tags, config.tags);
        (0, Options_js_1.defaultOptions)(this.options, config.options);
        Object.assign(this.nodes, config.nodes);
    };
    ParserConfiguration.prototype.addFilters = function (jax, config) {
        var e_5, _a, e_6, _b;
        try {
            for (var _c = __values(config.preprocessors), _d = _c.next(); !_d.done; _d = _c.next()) {
                var _e = __read(_d.value, 2), pre = _e[0], priority = _e[1];
                jax.preFilters.add(pre, priority);
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_5) throw e_5.error; }
        }
        try {
            for (var _f = __values(config.postprocessors), _g = _f.next(); !_g.done; _g = _f.next()) {
                var _h = __read(_g.value, 2), post = _h[0], priority = _h[1];
                jax.postFilters.add(post, priority);
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
            }
            finally { if (e_6) throw e_6.error; }
        }
    };
    return ParserConfiguration;
}());
exports.ParserConfiguration = ParserConfiguration;
//# sourceMappingURL=Configuration.js.map