/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
/**
 * Register the capabilities with the server capabilities provider
 *
 * @param serverCapabilities - server capabilities provider.
 * @param registration -  capabilities to be registered.
 * @return - the new server capabilities provider
 */
function registerServerCapability(serverCapabilities, registration) {
    const serverCapabilitiesCopy = JSON.parse(JSON.stringify(serverCapabilities));
    const { method, registerOptions } = registration;
    const providerName = method.substring(13) + 'Provider';
    if (providerName) {
        if (!registerOptions) {
            serverCapabilitiesCopy[providerName] = true;
        }
        else {
            serverCapabilitiesCopy[providerName] = JSON.parse(JSON.stringify(registerOptions));
        }
    }
    else {
        console.warn('Could not register server capability.', registration);
        return null;
    }
    return serverCapabilitiesCopy;
}
/**
 * Unregister the capabilities with the server capabilities provider
 *
 * @param serverCapabilities - server capabilities provider.
 * @param registration -  capabilities to be unregistered.
 * @return - the new server capabilities provider
 */
function unregisterServerCapability(serverCapabilities, unregistration) {
    const serverCapabilitiesCopy = JSON.parse(JSON.stringify(serverCapabilities));
    const { method } = unregistration;
    const providerName = method.substring(13) + 'Provider';
    delete serverCapabilitiesCopy[providerName];
    return serverCapabilitiesCopy;
}
export { registerServerCapability, unregisterServerCapability };
//# sourceMappingURL=server-capability-registration.js.map