import { LanguageIdentifier } from '../lsp';
import { IExtractedCode, IForeignCodeExtractor } from './types';
/**
 * The code extractor for the raw and markdown text.
 */
export declare class TextForeignCodeExtractor implements IForeignCodeExtractor {
    constructor(options: TextForeignCodeExtractor.IOptions);
    /**
     * The foreign language.
     */
    readonly language: LanguageIdentifier;
    /**
     * Should the foreign code be appended (False) to the previously established virtual document of the same language,
     * or is it standalone snippet which requires separate connection?
     */
    readonly standalone: boolean;
    /**
     * Extension of the virtual document (some servers check extensions of files), e.g. 'py' or 'R'.
     */
    readonly fileExtension: string;
    /**
     * The supported cell types.
     */
    readonly cellType: string[];
    /**
     * Test if there is any foreign code in provided code snippet.
     */
    hasForeignCode(code: string, cellType: string): boolean;
    /**
     * Split the code into the host and foreign code (if any foreign code was detected)
     */
    extractForeignCode(code: string): IExtractedCode[];
}
declare namespace TextForeignCodeExtractor {
    interface IOptions {
        /**
         * The foreign language.
         */
        language: string;
        /**
         * Should the foreign code be appended (False) to the previously established virtual document of the same language,
         * or is it standalone snippet which requires separate connection?
         */
        isStandalone: boolean;
        /**
         * Extension of the virtual document (some servers check extensions of files), e.g. 'py' or 'R'.
         */
        file_extension: string;
        /**
         * The supported cell types.
         */
        cellType: string[];
    }
}
export {};
