import { Term } from "./grammar";
export declare const MAX_CHAR = 65535;
export declare class Edge {
    readonly from: number;
    readonly to: number;
    readonly target: State;
    constructor(from: number, to: number, target: State);
    toString(): string;
}
export declare class State {
    readonly accepting: Term[];
    readonly id: number;
    edges: Edge[];
    constructor(accepting?: Term[], id?: number);
    edge(from: number, to: number, target: State): void;
    nullEdge(target: State): void;
    compile(): State;
    closure(): State[];
    findConflicts(occurTogether: (a: Term, b: Term) => boolean): Conflict[];
    cycleTerms(): Term[];
    reachable(f: (s: State, edges: Edge[]) => void): void;
    toString(): string;
    toArray(groupMasks: {
        [id: number]: number;
    }, precedence: readonly number[]): Uint16Array;
    stateMask(groupMasks: {
        [id: number]: number;
    }): number;
}
export declare class Conflict {
    readonly a: Term;
    readonly b: Term;
    soft: number;
    readonly exampleA: string;
    readonly exampleB?: string;
    constructor(a: Term, b: Term, soft: number, exampleA: string, exampleB?: string);
}
