export declare class Node {
    readonly start: number;
    constructor(start: number);
}
export declare class GrammarDeclaration extends Node {
    readonly rules: readonly RuleDeclaration[];
    readonly topRules: readonly RuleDeclaration[];
    readonly tokens: TokenDeclaration | null;
    readonly localTokens: readonly LocalTokenDeclaration[];
    readonly context: ContextDeclaration | null;
    readonly externalTokens: readonly ExternalTokenDeclaration[];
    readonly externalSpecializers: readonly ExternalSpecializeDeclaration[];
    readonly externalPropSources: readonly ExternalPropSourceDeclaration[];
    readonly precedences: PrecDeclaration | null;
    readonly mainSkip: Expression | null;
    readonly scopedSkip: readonly {
        expr: Expression;
        topRules: readonly RuleDeclaration[];
        rules: readonly RuleDeclaration[];
    }[];
    readonly dialects: readonly Identifier[];
    readonly externalProps: readonly ExternalPropDeclaration[];
    readonly autoDelim: boolean;
    constructor(start: number, rules: readonly RuleDeclaration[], topRules: readonly RuleDeclaration[], tokens: TokenDeclaration | null, localTokens: readonly LocalTokenDeclaration[], context: ContextDeclaration | null, externalTokens: readonly ExternalTokenDeclaration[], externalSpecializers: readonly ExternalSpecializeDeclaration[], externalPropSources: readonly ExternalPropSourceDeclaration[], precedences: PrecDeclaration | null, mainSkip: Expression | null, scopedSkip: readonly {
        expr: Expression;
        topRules: readonly RuleDeclaration[];
        rules: readonly RuleDeclaration[];
    }[], dialects: readonly Identifier[], externalProps: readonly ExternalPropDeclaration[], autoDelim: boolean);
    toString(): string;
}
export declare class RuleDeclaration extends Node {
    readonly id: Identifier;
    readonly props: readonly Prop[];
    readonly params: readonly Identifier[];
    readonly expr: Expression;
    constructor(start: number, id: Identifier, props: readonly Prop[], params: readonly Identifier[], expr: Expression);
    toString(): string;
}
export declare class PrecDeclaration extends Node {
    readonly items: readonly {
        id: Identifier;
        type: "left" | "right" | "cut" | null;
    }[];
    constructor(start: number, items: readonly {
        id: Identifier;
        type: "left" | "right" | "cut" | null;
    }[]);
}
export declare class TokenPrecDeclaration extends Node {
    readonly items: readonly (NameExpression | LiteralExpression)[];
    constructor(start: number, items: readonly (NameExpression | LiteralExpression)[]);
}
export declare class TokenConflictDeclaration extends Node {
    readonly a: NameExpression | LiteralExpression;
    readonly b: NameExpression | LiteralExpression;
    constructor(start: number, a: NameExpression | LiteralExpression, b: NameExpression | LiteralExpression);
}
export declare class TokenDeclaration extends Node {
    readonly precedences: readonly TokenPrecDeclaration[];
    readonly conflicts: readonly TokenConflictDeclaration[];
    readonly rules: readonly RuleDeclaration[];
    readonly literals: readonly LiteralDeclaration[];
    constructor(start: number, precedences: readonly TokenPrecDeclaration[], conflicts: readonly TokenConflictDeclaration[], rules: readonly RuleDeclaration[], literals: readonly LiteralDeclaration[]);
}
export declare class LocalTokenDeclaration extends Node {
    readonly precedences: readonly TokenPrecDeclaration[];
    readonly rules: readonly RuleDeclaration[];
    readonly fallback: {
        readonly id: Identifier;
        readonly props: readonly Prop[];
    } | null;
    constructor(start: number, precedences: readonly TokenPrecDeclaration[], rules: readonly RuleDeclaration[], fallback: {
        readonly id: Identifier;
        readonly props: readonly Prop[];
    } | null);
}
export declare class LiteralDeclaration extends Node {
    readonly literal: string;
    readonly props: readonly Prop[];
    constructor(start: number, literal: string, props: readonly Prop[]);
}
export declare class ContextDeclaration extends Node {
    readonly id: Identifier;
    readonly source: string;
    constructor(start: number, id: Identifier, source: string);
}
export declare class ExternalTokenDeclaration extends Node {
    readonly id: Identifier;
    readonly source: string;
    readonly tokens: readonly {
        id: Identifier;
        props: readonly Prop[];
    }[];
    constructor(start: number, id: Identifier, source: string, tokens: readonly {
        id: Identifier;
        props: readonly Prop[];
    }[]);
}
export declare class ExternalSpecializeDeclaration extends Node {
    readonly type: "extend" | "specialize";
    readonly token: Expression;
    readonly id: Identifier;
    readonly source: string;
    readonly tokens: readonly {
        id: Identifier;
        props: readonly Prop[];
    }[];
    constructor(start: number, type: "extend" | "specialize", token: Expression, id: Identifier, source: string, tokens: readonly {
        id: Identifier;
        props: readonly Prop[];
    }[]);
}
export declare class ExternalPropSourceDeclaration extends Node {
    readonly id: Identifier;
    readonly source: string;
    constructor(start: number, id: Identifier, source: string);
}
export declare class ExternalPropDeclaration extends Node {
    readonly id: Identifier;
    readonly externalID: Identifier;
    readonly source: string;
    constructor(start: number, id: Identifier, externalID: Identifier, source: string);
}
export declare class Identifier extends Node {
    readonly name: string;
    constructor(start: number, name: string);
    toString(): string;
}
export declare class Expression extends Node {
    walk(f: (expr: Expression) => Expression): Expression;
    eq(_other: Expression): boolean;
    prec: number;
}
export declare class NameExpression extends Expression {
    readonly id: Identifier;
    readonly args: readonly Expression[];
    constructor(start: number, id: Identifier, args: readonly Expression[]);
    toString(): string;
    eq(other: NameExpression): boolean;
    walk(f: (expr: Expression) => Expression): Expression;
}
export declare class SpecializeExpression extends Expression {
    readonly type: string;
    readonly props: readonly Prop[];
    readonly token: Expression;
    readonly content: Expression;
    constructor(start: number, type: string, props: readonly Prop[], token: Expression, content: Expression);
    toString(): string;
    eq(other: SpecializeExpression): boolean;
    walk(f: (expr: Expression) => Expression): Expression;
}
export declare class InlineRuleExpression extends Expression {
    readonly rule: RuleDeclaration;
    constructor(start: number, rule: RuleDeclaration);
    toString(): string;
    eq(other: InlineRuleExpression): boolean;
    walk(f: (expr: Expression) => Expression): Expression;
}
export declare class ChoiceExpression extends Expression {
    readonly exprs: readonly Expression[];
    constructor(start: number, exprs: readonly Expression[]);
    toString(): string;
    eq(other: ChoiceExpression): boolean;
    walk(f: (expr: Expression) => Expression): Expression;
}
export declare class SequenceExpression extends Expression {
    readonly exprs: readonly Expression[];
    readonly markers: readonly (readonly ConflictMarker[])[];
    readonly empty: boolean;
    constructor(start: number, exprs: readonly Expression[], markers: readonly (readonly ConflictMarker[])[], empty?: boolean);
    toString(): string;
    eq(other: SequenceExpression): boolean;
    walk(f: (expr: Expression) => Expression): Expression;
}
export declare class ConflictMarker extends Node {
    readonly id: Identifier;
    readonly type: "ambig" | "prec";
    constructor(start: number, id: Identifier, type: "ambig" | "prec");
    toString(): string;
    eq(other: ConflictMarker): boolean;
}
export declare class RepeatExpression extends Expression {
    readonly expr: Expression;
    readonly kind: "?" | "*" | "+";
    constructor(start: number, expr: Expression, kind: "?" | "*" | "+");
    toString(): string;
    eq(other: RepeatExpression): boolean;
    walk(f: (expr: Expression) => Expression): Expression;
}
export declare class LiteralExpression extends Expression {
    readonly value: string;
    constructor(start: number, value: string);
    toString(): string;
    eq(other: LiteralExpression): boolean;
}
export declare class SetExpression extends Expression {
    readonly ranges: [number, number][];
    readonly inverted: boolean;
    constructor(start: number, ranges: [number, number][], inverted: boolean);
    toString(): string;
    eq(other: SetExpression): boolean;
}
export declare class AnyExpression extends Expression {
    constructor(start: number);
    toString(): string;
    eq(): boolean;
}
export declare const CharClasses: {
    [name: string]: [number, number][];
};
export declare class CharClass extends Expression {
    readonly type: string;
    constructor(start: number, type: string);
    toString(): string;
    eq(expr: CharClass): boolean;
}
export declare function exprEq(a: Expression, b: Expression): boolean;
export declare function exprsEq(a: readonly Expression[], b: readonly Expression[]): boolean;
export declare class Prop extends Node {
    readonly at: boolean;
    readonly name: string;
    readonly value: readonly PropPart[];
    constructor(start: number, at: boolean, name: string, value: readonly PropPart[]);
    eq(other: Prop): boolean;
    toString(): string;
    static eqProps(a: readonly Prop[], b: readonly Prop[]): boolean;
}
export declare class PropPart extends Node {
    readonly value: string | null;
    readonly name: string | null;
    constructor(start: number, value: string | null, name: string | null);
}
