export type Props = {
    [name: string]: string;
};
export declare function hasProps(props: Props): boolean;
export declare class Term {
    readonly name: string;
    private flags;
    readonly nodeName: string | null;
    readonly props: Props;
    hash: number;
    id: number;
    rules: Rule[];
    constructor(name: string, flags: number, nodeName: string | null, props?: Props);
    toString(): string;
    get nodeType(): boolean;
    get terminal(): boolean;
    get eof(): boolean;
    get error(): boolean;
    get top(): boolean;
    get interesting(): boolean;
    get repeated(): boolean;
    set preserve(value: boolean);
    get preserve(): boolean;
    set inline(value: boolean);
    get inline(): boolean;
    cmp(other: Term): number;
}
export declare class TermSet {
    terms: Term[];
    names: {
        [name: string]: Term;
    };
    eof: Term;
    error: Term;
    tops: Term[];
    constructor();
    term(name: string, nodeName: string | null, flags?: number, props?: Props): Term;
    makeTop(nodeName: string | null, props: Props): Term;
    makeTerminal(name: string, nodeName: string | null, props?: {}): Term;
    makeNonTerminal(name: string, nodeName: string | null, props?: {}): Term;
    makeRepeat(name: string): Term;
    uniqueName(name: string): string;
    finish(rules: readonly Rule[]): {
        nodeTypes: Term[];
        names: {
            [id: number]: string;
        };
        minRepeatTerm: number;
        maxTerm: number;
    };
}
export declare function cmpSet<T>(a: readonly T[], b: readonly T[], cmp: (a: T, b: T) => number): number;
export declare class Conflicts {
    readonly precedence: number;
    readonly ambigGroups: readonly string[];
    readonly cut: number;
    constructor(precedence: number, ambigGroups?: readonly string[], cut?: number);
    join(other: Conflicts): Conflicts;
    cmp(other: Conflicts): number;
    static none: Conflicts;
}
export declare function union<T>(a: readonly T[], b: readonly T[]): readonly T[];
export declare class Rule {
    readonly name: Term;
    readonly parts: readonly Term[];
    readonly conflicts: readonly Conflicts[];
    readonly skip: Term;
    id: number;
    constructor(name: Term, parts: readonly Term[], conflicts: readonly Conflicts[], skip: Term);
    cmp(rule: Rule): number;
    cmpNoName(rule: Rule): number;
    toString(): string;
    get isRepeatWrap(): boolean;
    sameReduce(other: Rule): boolean;
}
