import { NodeProp, NodePropSource } from "@lezer/common";
import { LRParser, ExternalTokenizer, Stack, ContextTracker } from "@lezer/lr";
export type BuildOptions = {
    fileName?: string;
    warn?: (message: string) => void;
    includeNames?: boolean;
    moduleStyle?: string;
    exportName?: string;
    externalTokenizer?: (name: string, terms: {
        [name: string]: number;
    }) => ExternalTokenizer;
    externalPropSource?: (name: string) => NodePropSource;
    externalSpecializer?: (name: string, terms: {
        [name: string]: number;
    }) => (value: string, stack: Stack) => number;
    externalProp?: (name: string) => NodeProp<any>;
    contextTracker?: ContextTracker<any>;
};
export declare function buildParser(text: string, options?: BuildOptions): LRParser;
export declare function buildParserFile(text: string, options?: BuildOptions): {
    parser: string;
    terms: string;
};
