import { Term, TermSet, Rule, Conflicts } from "./grammar";
export declare class Pos {
    readonly rule: Rule;
    readonly pos: number;
    readonly ahead: Term[];
    ambigAhead: readonly string[];
    readonly skipAhead: Term;
    readonly via: Pos | null;
    hash: number;
    constructor(rule: Rule, pos: number, ahead: Term[], ambigAhead: readonly string[], skipAhead: Term, via: Pos | null);
    finish(): this;
    get next(): Term;
    advance(): Pos;
    get skip(): Term;
    cmp(pos: Pos): number;
    eqSimple(pos: Pos): boolean;
    toString(): string;
    eq(other: Pos): boolean;
    trail(maxLen?: number): string;
    conflicts(pos?: number): Conflicts;
    static addOrigins(group: readonly Pos[], context: readonly Pos[]): Pos[];
}
export declare class Shift {
    readonly term: Term;
    readonly target: State;
    constructor(term: Term, target: State);
    eq(other: Shift | Reduce): boolean;
    cmp(other: Shift | Reduce): number;
    toString(): string;
    map(mapping: readonly number[], states: readonly State[]): Shift;
}
export declare class Reduce {
    readonly term: Term;
    readonly rule: Rule;
    constructor(term: Term, rule: Rule);
    eq(other: Shift | Reduce): boolean;
    cmp(other: Shift | Reduce): number;
    toString(): string;
    map(): this;
}
export declare class State {
    id: number;
    set: readonly Pos[];
    flags: number;
    readonly skip: Term;
    readonly hash: number;
    readonly startRule: Term | null;
    actions: (Shift | Reduce)[];
    actionPositions: (readonly Pos[])[];
    goto: Shift[];
    tokenGroup: number;
    defaultReduce: Rule | null;
    constructor(id: number, set: readonly Pos[], flags: number, skip: Term, hash?: number, startRule?: Term | null);
    toString(): string;
    addActionInner(value: Shift | Reduce, positions: readonly Pos[]): Shift | Reduce | null;
    addAction(value: Shift | Reduce, positions: readonly Pos[], conflicts: Conflict[]): void;
    getGoto(term: Term): Shift;
    hasSet(set: readonly Pos[]): boolean;
    finish(): void;
    eq(other: State): boolean;
}
export declare function computeFirstSets(terms: TermSet): {
    [term: string]: Term[];
};
declare class Conflict {
    readonly error: string;
    readonly rules: readonly Term[];
    constructor(error: string, rules: readonly Term[]);
}
export declare function buildFullAutomaton(terms: TermSet, startTerms: Term[], first: {
    [name: string]: Term[];
}): State[];
export declare function finishAutomaton(full: readonly State[]): readonly State[];
export {};
