import { SourceChange } from '@jupyter/ydoc';
import { CompletionHandler } from './handler';
import { ICompletionContext, ICompletionProvider, IProviderReconciliator } from './tokens';
/**
 * The reconciliator which is used to fetch and merge responses from multiple completion providers.
 */
export declare class ProviderReconciliator implements IProviderReconciliator {
    /**
     * Creates an instance of ProviderReconciliator.
     */
    constructor(options: ProviderReconciliator.IOptions);
    /**
     * Fetch response from multiple providers, If a provider can not return
     * the response for a completer request before timeout,
     * the result of this provider will be ignored.
     *
     * @param {CompletionHandler.IRequest} request - The completion request.
     */
    fetch(request: CompletionHandler.IRequest): Promise<CompletionHandler.ICompletionItemsReply | null>;
    /**
     * Check if completer should make request to fetch completion responses
     * on user typing. If the provider with highest rank does not have
     * `shouldShowContinuousHint` method, a default one will be used.
     *
     * @param completerIsVisible - The visible status of completer widget.
     * @param changed - CodeMirror changed argument.
     */
    shouldShowContinuousHint(completerIsVisible: boolean, changed: SourceChange): boolean;
    private _alignPrefixes;
    private _mergeCompletions;
    private _defaultShouldShowContinuousHint;
    private _resolveFactory;
    /**
     * List of available providers.
     */
    private _providers;
    /**
     * Current completer context.
     */
    private _context;
    /**
     * Timeout for the fetch request.
     */
    private _timeout;
    /**
     * Counter to reject current provider response if a new fetch request is created.
     */
    private _fetching;
}
export declare namespace ProviderReconciliator {
    /**
     * The instantiation options for provider reconciliator.
     */
    interface IOptions {
        /**
         * Completion context that will be used in the `fetch` method of provider.
         */
        context: ICompletionContext;
        /**
         * List of completion providers, assumed to contain at least one provider.
         */
        providers: ICompletionProvider[];
        /**
         * How long should we wait for each of the providers to resolve `fetch` promise
         */
        timeout: number;
    }
}
